/**
* @file        :  CameraGui.cpp
* @addtogroup  :  AppHmi_Camera
* @brief       :  Class which contains all the necessary business logic required to handle gui instance and gadgets
* @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*/
#include "gui_std_if.h"
#include "CameraGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_CAMERA_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Camera_"
#define ETG_I_FILE_PREFIX                 App::Core::CameraGui::
#include "trcGenProj/Header/CameraGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_TUNER), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_TUNER), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_TUNER))
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TESTMODE, SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TESTMODE, SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TESTMODE, SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TESTMODE, SURFACEID_CENTER_POPUP_SURFACE_TESTMODE)
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_CAMERA,SURFACEID_NONE, SURFACEID_NONE, SURFACEID_NONE)
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_CAMERA),
//
                            //     APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_NONE),
                            //    APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_NONE)

                            APPSETTINGS_END()

                            using namespace ::hmi;

namespace App {
namespace Core {

CameraGui::CameraGui() : GuiComponentBase(hmi::apps::reference::appHmi_Camera, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_CAMERA_APPCTRL_PROXY);
   uint32 DisplayID_D1 = 1;
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_CAMERA, DisplayID_D1);
   SYNC_BLOCK_CONNECTION(765, CAMERA_GADGET);
   SYNC_BLOCK_CONNECTION(765, CAMERA_GADGET_CABIN);
   SYNC_BLOCK_CONNECTION(765, CAMERA_GADGET_NON_NAVI);
   SYNC_BLOCK_CONNECTION(765, CAMERA_GADGET_CABIN_NON_NAVI);
   // ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_TUNER, DisplayID_D1);
   // ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_TUNER, DisplayID_D1);
}


CameraGui::~CameraGui()
{
   ETG_I_UNREGISTER_FILE();
}


unsigned int CameraGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_CAMERA_MAIN;
}


void CameraGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void CameraGui::preRun()
{
   //   DP_vCreateDatapool();
   PersistentValuesRead();
}


void CameraGui::postRun()
{
   PersistentValuesWrite();
}


void CameraGui::PersistentValuesRead()
{
   //   dp_tclhmiAppSxmPersMemVarsSxm dp;
   //   _mvar = dp.tGetData();
}


void CameraGui::PersistentValuesWrite()
{
   //   dp_tclhmiAppSxmPersMemVarsSxm dp;
   //   dp.s32SetData(_mvar);
}


/**
*sink for not processed ttfis input messages
*/
void CameraGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
