/**************************************************************************************
* @file         : CameraDataBindingHandler.h
* @author       : ECH2 - Somanath Baddi
* @addtogroup   : Camera HALL
* @brief        : Class contains utility functions to handle DataBinding messages required for Camera data.
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef CameraDataBindingHandler_H
#define CameraDataBindingHandler_H

#include <AppHmi_CameraMessages.h>
#include "HmiTranslation_TextIds.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CgiExtensions/ImageLoader.h"
#include "AppHmi_CameraStateMachine.h"
#include "AppHmi_CameraDatabinding.h"
#include "AppBase/HallComponentBase.h"


using namespace std;
namespace App {
namespace Core {

class CameraDataBindingHandler
{
   public:
      virtual ~CameraDataBindingHandler();
      static CameraDataBindingHandler* poGetInstance()
      {
         if (NULL == m_poCameraDataBindingHandler)
         {
            m_poCameraDataBindingHandler = new CameraDataBindingHandler();
         }

         return m_poCameraDataBindingHandler;
      }

      void updateCameraNameInTile(int camName);
      void updateCameraNameInStreamScreen(int camName);
      void vShowCameraWarningText(bool camValue);
      void vShowHomeScreenNextPrevButtons(int value);
      void vCameraStreamToggle(bool m_ToggleVisible);
      void vCamAvailability(bool value);
      void vCamAvailabilityCabin(bool CMGvalue, bool CMPvalue);
      void vMixSourceAvailability(bool value);
      void vMixSourceText(uint32 value, int index);
      static void TraceCmd_onCMPActiveStatus(bool cmpActive);
      static void TraceCmd_onCMGActiveStatus(bool cmgActive, bool cmpActive);
      static void TraceCmd_onKDSHeaderFooterStatus(bool kdsheaderfooter);
      void  dummyfunction(bool dummykdsheaderfooter);
      DataBindingItem<CameraSelectSourceDataBindingSource> oCameraInfoData;
      DataBindingItem<HideButtonCabinDataBindingSource> oHideButton;
      DataBindingItem<ToggleCameraSceneDataBindingSource> oCameraVisibleBtn;

      void showRestorationText();
      void SetRVCMsgposition(float x_cord, float y_cord);
      void OnLanguageChange(int languageIndex);
      uint8 CurrentLanguageSet();

   private:
      static CameraDataBindingHandler* m_poCameraDataBindingHandler;
      CameraDataBindingHandler();
      CameraDataBindingHandler(const CameraDataBindingHandler&);
      CameraDataBindingHandler& operator =(const CameraDataBindingHandler&);

      uint8 currentLanguageIndexSet;
      //bool rxdcurrentkdsheaderfooter;
      uint8 m_RvcMsgPositionInfo;
};


}  //Core
}  //App

#endif
