/**************************************************************************************
* @file         : CameraDataBindingHandler.cpp
* @author       : ECH2 - Somanath Baddi
* @addtogroup   : Camera HALL
* @brief        : Class contains utility functions to handle DataBinding messages required for Camera data.
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "CameraDataBindingHandler.h"
#include "CameraListHandler.h"
#include "CameraMain.h"
#include "KDSHandler.h"
#include "VehicleClientHandler/VehicleClientHandler.h"
#include "CameraSourceChangeHandler/CameraSourceChangeHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_CAMERA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Camera_"
#define ETG_I_FILE_PREFIX                 App::Core::CameraDataBindingHandler::
#include "trcGenProj/Header/CameraDataBindingHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {
CameraDataBindingHandler* CameraDataBindingHandler::m_poCameraDataBindingHandler = NULL;

CameraDataBindingHandler::CameraDataBindingHandler()
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("CameraDataBindingHandler : Constructor"));
   (*oCameraInfoData).mCamera_Tile = "";
   (*oCameraInfoData).mCamera_Cockpit = "";
   (*oCameraInfoData).mSource_Name = "";
   (*oCameraInfoData).mCamera_TileA2 = "NONE";   // replace with textID
   (*oCameraInfoData).mVisible_Txt = false;
   (*oCameraInfoData).mCamera_Availability = false;
   (*oCameraInfoData).mCamera_BG = 0;
   (*oCameraVisibleBtn).mShowHideSceneButtons = true;
   (*oCameraVisibleBtn).mLoading_text_visibility = true;
   (*oHideButton).mHidePrevious = 0;
   (*oHideButton).mHideNext = 0;
   (*oHideButton).mToggleIcon = 1;
   (*oHideButton).mLoadingTextCabin = true;
   (*oHideButton).mCamTextCabin = false;
   (*oHideButton).mCam_BG_Cabin = false;
   (*oHideButton).mHideMixSource = false;
   currentLanguageIndexSet = 0;
   m_RvcMsgPositionInfo = KDSHandler::poGetInstance()->u8GetRvcMsgPositionValue();
   ETG_TRACE_USR3(("CameraDataBindingHandler::CameraDataBindingHandler m_RvcMsgPositionInfo (%d)", m_RvcMsgPositionInfo));
   //rxdcurrentkdsheaderfooter = 0;
}


CameraDataBindingHandler::~CameraDataBindingHandler()
{
   if (m_poCameraDataBindingHandler != NULL)
   {
      delete m_poCameraDataBindingHandler;
   }
   ETG_I_UNREGISTER_FILE();
}


void CameraDataBindingHandler::updateCameraNameInTile(int camName)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler : updateCameraNameInTile %u", camName));
   (*oCameraInfoData).mCamera_Tile = (Candera::String)camName;
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();
}


void CameraDataBindingHandler::updateCameraNameInStreamScreen(int camName)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler : updateCameraNameInStreamScreen %u", camName));
   (*oCameraInfoData).mSource_Name = (Candera::String)camName;
   (*oCameraInfoData).mCamera_Cockpit = (Candera::String)camName;
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();
}


void CameraDataBindingHandler::SetRVCMsgposition(float cordinate_x, float cordinate_y)
{
   ETG_TRACE_USR3(("CameraMain::SetRVCMsgposition cordinate_x , cordinate_y (%d) (%d)", cordinate_x, cordinate_y));

   (*oCameraInfoData).mRVC_Warning_Visiblity = RVC_MSG_HIDE;
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();

   uint8 currentlanguageIndex = CurrentLanguageSet();
   ETG_TRACE_USR3(("CameraMain::SetRVCMsgposition cordinate_x , cordinate_y currentLanguageIndexSet currentlanguageIndex RVC_MSG_HIDE (%d) (%d) (%d) (%d)", cordinate_x, cordinate_y, currentLanguageIndexSet, currentlanguageIndex));
   (*oCameraInfoData).mRVC_Warning_Language = currentlanguageIndex;

   Candera::Vector2 headerfooterposition(cordinate_x, cordinate_y);
   (*oCameraInfoData).mRVC_Warning_PosCordinates = headerfooterposition;

   (*oCameraInfoData).mRVC_Warning_Visiblity = RVC_MSG_SHOW;
   ETG_TRACE_USR3(("CameraMain::SetRVCMsgposition cordinate_x , cordinate_y currentLanguageIndexSet RVC_MSG_SHOW (%d) (%d) (%d)", cordinate_x, cordinate_y, currentLanguageIndexSet));
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();
}


void CameraDataBindingHandler::OnLanguageChange(int languageIndex)
{
   ETG_TRACE_USR3(("CameraDataBindingHandler::OnLanguageChange languageIndex %d ", languageIndex));
   currentLanguageIndexSet = languageIndex;
}


uint8 CameraDataBindingHandler::CurrentLanguageSet()
{
   ETG_TRACE_USR3(("CameraDataBindingHandler::CurrentLanguageSet currentLanguageIndexSet %d ", currentLanguageIndexSet));
   return currentLanguageIndexSet;
}


void CameraDataBindingHandler::vShowCameraWarningText(bool camValue)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText %d", camValue));
   //int selectedIndex = CameraListHandler::getInstance()->getSelectedCockpitCameraIndex();
   if (camValue == TRUE)
   {
      if (m_poCameraDataBindingHandler != NULL)
      {
         //  bool rxdcurrentkdsheaderfooter = CameraMain::poGetInstance()->Currentkdsheaderfooterupdate();
         bool currentViewMode = CameraMain::poGetInstance()->GetToggleValue();
         ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText m_RvcMsgPositionInfo currentViewMode %d %d", m_RvcMsgPositionInfo, currentViewMode));

         if (m_RvcMsgPositionInfo == RVC_MSG_FOOTER) //RVC_MSG_FOOTER-0
         {
            ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText::Bottam"));
            m_poCameraDataBindingHandler ->SetRVCMsgposition(RVC_MSG_X_AXIS_ALL_POSITION, RVC_MSG_Y_AXIS_BOTTOM_NORMAL_FULL_MODE_POS); //vShowCameraWarningText Bottom
         }
         else if ((m_RvcMsgPositionInfo == RVC_MSG_HEADER) && (currentViewMode == RVC_FULLMODE)) 			// RVC_NORMALMODE-0 //RVC_MSG_HEADER-1
         {
            ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText::Top FULL MODE"));
            m_poCameraDataBindingHandler ->SetRVCMsgposition(RVC_MSG_X_AXIS_ALL_POSITION, RVC_MSG_Y_AXIS_TOP_FULL_MODE_POS); //vShowCameraWarningText Top FULL
         }
         else if ((m_RvcMsgPositionInfo == RVC_MSG_HEADER) && (currentViewMode == RVC_NORMALMODE))			// RVC_NORMALMODE-0 //RVC_MSG_HEADER-1
         {
            ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText::Top NORMAL MODE"));
            m_poCameraDataBindingHandler ->SetRVCMsgposition(RVC_MSG_X_AXIS_ALL_POSITION, RVC_MSG_Y_AXIS_TOP_NORMAL_MODE_POS); //vShowCameraWarningText Top Normal
         }

         ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText::ENABLED"));
      }
   }
   else
   {
      if (m_poCameraDataBindingHandler != NULL)
      {
         ETG_TRACE_USR4(("CameraDataBindingHandler : vShowCameraWarningText  DISABLED"));
         (*oCameraInfoData).mRVC_Warning_Visiblity = RVC_MSG_HIDE;
         oCameraInfoData.MarkAllItemsModified();
         oCameraInfoData.SendUpdate();
      }
   }
}


void CameraDataBindingHandler::vShowHomeScreenNextPrevButtons(int value)
{
   switch (value)
   {
      case 0:													//When camera is turned off.
         (*oHideButton).mHidePrevious = false;
         (*oHideButton).mHideNext = false;
         (*oHideButton).mToggleIcon = 1;
         (*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x13A7));
         break;
      case 1:													// When camera is On and camera selected index is greater than 1 and less than Max camera
         (*oHideButton).mHidePrevious = true;
         (*oHideButton).mHideNext = true;
         (*oHideButton).mToggleIcon = 0;
         (*oHideButton).mCam_BG_Cabin = true;
         //(*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x157A));
         break;
      case 2:
         (*oHideButton).mHidePrevious = true;					//When selected camera is the last one.
         (*oHideButton).mHideNext = false;
         (*oHideButton).mCam_BG_Cabin = true;
         break;
      case 3:
         (*oHideButton).mHidePrevious = false;					//When selected camera is the first one.
         (*oHideButton).mHideNext = true;
         (*oHideButton).mCam_BG_Cabin = true;
         break;
      default:
         break;
   }

   oCameraInfoData.MarkAllItemsModified();// CID_R2 3037159
   oCameraInfoData.SendUpdate();
   oHideButton.MarkAllItemsModified();
   oHideButton.SendUpdate();
}


void CameraDataBindingHandler::vCameraStreamToggle(bool m_ToggleVisible)
{
   (*oCameraVisibleBtn).mShowHideSceneButtons = m_ToggleVisible;
   oCameraVisibleBtn.MarkItemModified(ItemKey::ToggleCameraScene::ShowHideSceneButtonsItem);
   oCameraVisibleBtn.SendUpdate(true);
}


void CameraDataBindingHandler::vCamAvailability(bool value)
{
   int selectedIndex = CameraListHandler::getInstance()->getSelectedCockpitCameraIndex();
   int camName = CameraListHandler::getInstance()->getActiveCameraName(selectedIndex);
   vector<int> camTextId = CameraListHandler::getInstance()->getAvailableCameraTextIdOnSelection();
   ETG_TRACE_USR4(("CameraDataBindingHandler : vCamAvailability value %d selectedIndex %d camNmae %d camTextId size %d", value, selectedIndex, camName, camTextId.size()));
   if ((value == true))// && (cockpitSize > 0))
   {
      sm_gCMPStatus = 1;												// Set the SM variable to true when CMP1 becomes available.
      if (camTextId.size() == 0)
      {
         (*oCameraInfoData).mCamera_Availability = false;
         (*oCameraInfoData).mCamera_BG = 0;
         (*oCameraVisibleBtn).mCam_text_visibility = true;
         (*oCameraVisibleBtn).mLoading_text_visibility = false;
         (*oCameraInfoData).mCamera_Cockpit = Candera::String((TextId_0x1A0B));
         oCameraInfoData.MarkAllItemsModified();
         oCameraInfoData.SendUpdate();
         oCameraVisibleBtn.MarkAllItemsModified();
         oCameraVisibleBtn.SendUpdate();
      }
      else
      {
         CameraMain::poGetInstance()->vAppflyinStatusInfo(true);
         sm_gCMPStatus = 1;
         (*oCameraInfoData).mCamera_Availability = true;
         (*oCameraInfoData).mCamera_BG = 1;
         (*oCameraVisibleBtn).mCam_text_visibility = true;
         (*oCameraVisibleBtn).mLoading_text_visibility = false;
         if (selectedIndex < 0)
         {
            (*oCameraInfoData).mCamera_Cockpit = Candera::String((TextId_0x13A7));
         }
         else
         {
            (*oCameraInfoData).mCamera_Cockpit = Candera::String(camName);
         }
         oCameraInfoData.MarkAllItemsModified();
         oCameraInfoData.SendUpdate();
         oCameraVisibleBtn.MarkAllItemsModified();
         oCameraVisibleBtn.SendUpdate();
         VehicleClientHandler::getInstance()->checkAnyCameraActiveOnStartup();
      }
   }
   else
   {
      CameraMain::poGetInstance()->vAppflyinStatusInfo(false);
      sm_gCMPStatus = 0;
      (*oCameraInfoData).mCamera_Availability = false;
      (*oCameraInfoData).mCamera_BG = 0;
      (*oCameraVisibleBtn).mLoading_text_visibility = true;
      (*oCameraVisibleBtn).mCam_text_visibility = false;
      (*oCameraInfoData).mCamera_Cockpit = Candera::String((TextId_0x1925));
      oCameraInfoData.MarkAllItemsModified();
      oCameraInfoData.SendUpdate();
      oCameraVisibleBtn.MarkAllItemsModified();
      oCameraVisibleBtn.SendUpdate();
   }
}


void CameraDataBindingHandler::vCamAvailabilityCabin(bool CMGValue, bool CMPValue)
{
   int selectedIndex = CameraListHandler::getInstance()->getSelectedCameraIndex();
   int camName = CameraListHandler::getInstance()->getActiveCameraNameCabin(selectedIndex);
   int cabinKDSValue = KDSHandler::poGetInstance()->u8GetCabinCameraKDSValue();
   vector<int> camTextId = CameraListHandler::getInstance()->getAvailableCabinCamTxtIdOnSelection();//getAvailableCameraTextIdOnSelection();
   int ipCamCount = CameraSourceChangeHandler::getInstance()-> getIPCamCount();
   int a2GlassCount = CameraSourceChangeHandler::getInstance()->getA2GlassCount();

   ETG_TRACE_USR4(("CameraDataBindingHandler::vCamAvailabilityCabin cabinKDSValue==>%d,ipCamCount==>%d a2GlassCount==>%d", cabinKDSValue, ipCamCount, a2GlassCount));
   ETG_TRACE_USR4(("CameraDataBindingHandler::vCamAvailabilityCabin CMGValue %d CMPValue %d camNmae %d camTextId size %d", CMGValue, CMPValue, camName, camTextId.size()));

   if ((CMPValue == true) && (CMGValue == true) && (cabinKDSValue == 1)) //&& (cabinSize > 0))
   {
      if (camTextId.size() == 0)
      {
         vMixSourceAvailability(false);
         (*oHideButton).mLoadingTextCabin = false;
         (*oHideButton).mCamTextCabin = true;
         (*oHideButton).mCam_BG_Cabin = false;
         (*oHideButton).mToggleIcon = 1;
         (*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x1A0B));    // NO CAMERA CONFIGURED.
         oHideButton.MarkAllItemsModified();
         oHideButton.SendUpdate();
         oCameraInfoData.MarkAllItemsModified();
         oCameraInfoData.SendUpdate();
      }
      else
      {
         sm_gCMGStatus = 1;
         (*oHideButton).mLoadingTextCabin = false;
         (*oHideButton).mCamTextCabin = true;
         (*oHideButton).mCam_BG_Cabin = true;
         //CameraMain::poGetInstance()->setToggleValue(false);
         //(*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x13A7)); //To be removed after Including the entire list
         if (selectedIndex < 0)
         {
            (*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x13A7));    // CAMERA STREAMING STOPPED
            (*oHideButton).mToggleIcon = 1;
            CameraMain::poGetInstance()->setToggleValue(false);
         }
         else
         {
            (*oCameraInfoData).mCamera_Tile = Candera::String(camName);    // ACTIVE CAMERA NAME
            (*oHideButton).mToggleIcon = 0;
            CameraMain::poGetInstance()->setToggleValue(true);
         }
         oHideButton.MarkAllItemsModified();
         oHideButton.SendUpdate();
         oCameraInfoData.MarkAllItemsModified();
         oCameraInfoData.SendUpdate();
         if ((ipCamCount > 0) && (a2GlassCount > 0))
         {
            vMixSourceAvailability(true);
         }
         else
         {
            vMixSourceAvailability(false);
         }
      }
   }
   else
   {
      sm_gCMGStatus = 0;
      vMixSourceAvailability(false);
      (*oHideButton).mLoadingTextCabin = true;
      (*oHideButton).mCamTextCabin = false;
      (*oHideButton).mCam_BG_Cabin = false;
      (*oHideButton).mToggleIcon = 1;
      CameraMain::poGetInstance()->setToggleValue(true);
      //(*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x1925));    // function not avaialable
      oHideButton.MarkAllItemsModified();
      oHideButton.SendUpdate();
      oCameraInfoData.MarkAllItemsModified();
      oCameraInfoData.SendUpdate();
   }
}


void CameraDataBindingHandler::showRestorationText()
{
   (*oHideButton).mLoadingTextCabin = false;
   (*oHideButton).mCamTextCabin = true;
   oHideButton.MarkAllItemsModified();
   oHideButton.SendUpdate();
   (*oCameraInfoData).mCamera_Tile = Candera::String((TextId_0x1A1D));    // restoration in progress
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();
}


void CameraDataBindingHandler::vMixSourceAvailability(bool value)
{
   ETG_TRACE_USR4(("void CameraDataBindingHandler::vMixSourceAvailability mHideMixSource value=%d,", value));
   if (value != false)
   {
      (*oHideButton).mHideMixSource = true;
   }
   else
   {
      (*oHideButton).mHideMixSource = false;
   }
   oHideButton.MarkAllItemsModified();
   oHideButton.SendUpdate();
}


/*Function to update the video mix source text DataBinding Based on m_MixSrctoggle Toggle Flag*/
void CameraDataBindingHandler::vMixSourceText(uint32 value, int index)
{
   ETG_TRACE_USR4(("void CameraDataBindingHandler::vMixSourceText mCamera_TileA2 value=%d,index=%d", value, index));
   if ((index == 0) || (index == 1))
   {
      if (index == 1) // 	Bug 1619947: Panoramic camera activation in Cabin A2 via Video mixed mode button in camera tile does not work on single click during active Mapout streaming
      {
         ETG_TRACE_USR4(("void CameraDataBindingHandler::vMixSourceText m_MixSrctoggle is been reset on index is 1 (MAPOUT)"));
         CameraMain::poGetInstance()->setMixToggleFlag(false);
      }
      (*oCameraInfoData).mCamera_TileA2 = "NONE"; // update camera streamed on a2
   }
   else
   {
      (*oCameraInfoData).mCamera_TileA2 = Candera::String((value));
   }
   oCameraInfoData.MarkAllItemsModified();
   oCameraInfoData.SendUpdate();
}


ETG_I_CMD_DEFINE((TraceCmd_onCMPActiveStatus, "CMPActiveStatus %d", bool))
void CameraDataBindingHandler::TraceCmd_onCMPActiveStatus(bool cmpActive)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler::TraceCmd_onCMPActiveStatus"));
   m_poCameraDataBindingHandler -> vCamAvailability(cmpActive);
}


ETG_I_CMD_DEFINE((TraceCmd_onCMGActiveStatus, "CMGActiveStatus %d %d", bool, bool))
void CameraDataBindingHandler::TraceCmd_onCMGActiveStatus(bool cmgActive, bool cmpActive)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler::TraceCmd_onCMGActiveStatus"));
   m_poCameraDataBindingHandler -> vCamAvailabilityCabin(cmgActive, cmpActive);
}


ETG_I_CMD_DEFINE((TraceCmd_onKDSHeaderFooterStatus, "KDSHeaderFooterStatus %d", bool))
void CameraDataBindingHandler::TraceCmd_onKDSHeaderFooterStatus(bool kdsheaderfooter)
{
   ETG_TRACE_USR4(("CameraDataBindingHandler::TraceCmd_onKDSHeaderFooterStatus kdsheaderfooter==>%d", kdsheaderfooter));
   if (m_poCameraDataBindingHandler != NULL)
   {
      m_poCameraDataBindingHandler ->dummyfunction(kdsheaderfooter);
   }
}


void CameraDataBindingHandler::dummyfunction(bool dummykdsheaderfooter)
{
   bool rxdsetkdsheaderfooter = CameraMain::poGetInstance()->SetkdsheaderfooterValue(dummykdsheaderfooter);
   ETG_TRACE_USR4(("CameraDataBindingHandler::dummyfunction %d", rxdsetkdsheaderfooter));
}


}  //Core
} //App
