/* ***************************************************************************************
* FILE:          CameraAvdeccClientHandler.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  CameraAvdeccClientHandler.h is part of Camera HMI
* COPYRIGHT:  (c) 2021-22 Robert Bosch Car Multimedia GmbH
* HISTORY:
* AUTHOR:
* REVISION:
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CameraAvdeccClientHandler_h
#define CameraAvdeccClientHandler_h

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "AVRoutingParser.h"
#include <map>
#include <iostream>
#include <bits/stdc++.h>

//defines used locally in camera plugin
#define ONE 1
#define TWO 2
#define THREE 3
#define FOUR 4
#define ONECMP_MAXCAMERAS 5
#define IPCAM_INCMP 4
#define CAMLIST_STARTUP 100
//


namespace App {
namespace Core {

class CameraAvdeccClientHandler
{
   public:
      CameraAvdeccClientHandler();
      static CameraAvdeccClientHandler* getInstance();
      static void deleteInstance();
      virtual ~CameraAvdeccClientHandler();

      void fillDataInVector(int indexCMP, int loopSize);

      void sendCameraListDataToHMI(int loopsize);//CameraList cameraDataToHMI);
      void sendCameraListOnHMIRequest(); // new method added to handle request from HMI.
      std::map<std::string, int> mapCmpSrc_AvdeccValue;
      void getAvdeccValue(std::string camSrc, int& avdeccValue);
      void readCameraConfig();
      tclAvRoutingParser* _avRoutingParser;

      //void fillTestDataToHMI();
      void vCheckAndAddIPCamera(int numberOfCMPs);
      void vCheckAndAddSplitCamera(int numberOfCMPs);
      tVoid vPrintCamInfo();
      void fillSplitDataInVector(int indexCMP, int loopSize);
      std::string strSplitCamSrcName[3] = {"cockpitSplitView1", "cockpitSplitView2", "cockpitSplitView3"};
      int getSplitAvdeccValue(int position, std::string cameraSrc);
      void vPrepareAvdeccValuesForSplitCameras();
      int m_numberofCMPS;
      int getIPCameraIndexFromCamport(std::string ipcamstr);
      bool bPrimaryDetected;

      void requestCameraListDataFromHMI(int CMPValue);

   private:
      CameraAvdeccClientHandler(const CameraAvdeccClientHandler&);
      CameraAvdeccClientHandler& operator =(const CameraAvdeccClientHandler&);
      static CameraAvdeccClientHandler* poSelf;

      int getCamportIndex(int position);

      tVecCamData m_caminfo;
      tVecCamData vecCamDataToHmi;
      tVecCamData vecCamDataOnHmiRequest;
      tVecCamData CameraList;
      tCamData CL;

      vecCamPortSplitInfo m_splitCaminfo;
      vecCamPortAvdeccSplitValue	m_splitAvdeccinfo;
      tVecSplitCamData m_camSplitData;
};


}
}


#endif // !defined(CameraAvdeccClientHandler_h)
