/* ***************************************************************************************
* FILE:          CameraAvdeccClientHandler.cpp
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  CameraAvdeccClientHandler.cpp is part of camera hmi
* COPYRIGHT:  (c) 2021-22 Robert Bosch Car Multimedia GmbH
* HISTORY:
* AUTHOR:
* REVISION:
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include <CameraAvdeccClientHandler.h>
#include <CameraMain.h>
#include <map>
#include <iostream>
#include <string>
#include <bits/stdc++.h>
#include "hall_std_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_CAMERA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_CAMERA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Camera_"
#define ETG_I_FILE_PREFIX                 App::Core::CameraAvdeccClientHandler::
#include "trcGenProj/Header/CameraAvdeccClientHandler.cpp.trc.h"
#endif

using namespace std;

namespace App {
namespace Core {


CameraAvdeccClientHandler* CameraAvdeccClientHandler::poSelf = NULL;
CameraAvdeccClientHandler::CameraAvdeccClientHandler()
{
   vecCamDataToHmi.clear();
   vecCamDataOnHmiRequest.clear();
   m_numberofCMPS = 0;
   //make pair
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP1_CAM1", 1));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP1_CAM2", 2));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP1_CAM3", 4));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP1_CAM4", 8));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP2_CAM1", 1));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP2_CAM2", 2));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP2_CAM3", 4));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP2_CAM4", 8));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP3_CAM1", 1));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP3_CAM2", 2));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP3_CAM3", 4));
   mapCmpSrc_AvdeccValue.insert(pair<std::string, int>("CMP3_CAM4", 8));

   _avRoutingParser = tclAvRoutingParser::pGetInstance();
   if (_avRoutingParser != NULL)
   {
      bool m_bParseState = _avRoutingParser->bParseXml();
      ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig _avRoutingParser m_bParseState %d", m_bParseState));
      if (m_bParseState == true)
      {
         readCameraConfig();
      }
   }
   bPrimaryDetected = false;
}


CameraAvdeccClientHandler::~CameraAvdeccClientHandler()
{
   vecCamDataToHmi.clear();
   vecCamDataOnHmiRequest.clear();
   bPrimaryDetected = false;
}


CameraAvdeccClientHandler* CameraAvdeccClientHandler::getInstance()
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::getInstance"));
   if (poSelf == NULL)
   {
      ETG_TRACE_USR4(("Creating object CameraAvdeccClientHandler"));
      poSelf = new CameraAvdeccClientHandler();
   }
   ETG_TRACE_USR4(("Return object CameraAvdeccClientHandler %d", poSelf));
   return poSelf;
}


void CameraAvdeccClientHandler::deleteInstance()
{
   if (NULL != poSelf)
   {
      delete poSelf;
   }
}


// void CameraAvdeccClientHandler::requestCameraListDataFromHMI(int CMPValue)
// {
// int value = 0;
// ETG_TRACE_USR4(("CameraAvdeccClientHandler::requestCameraListDataFromHMI %d", CMPValue));
// switch (CMPValue)
// {
// case 1: value = 1;
// break;
// case 3: value = 2;
// break;
// case 7: value = 3;
// break;
// case 0: //clear list
// break;
// }
// sendCameraListDataToHMI(value);
// }


void CameraAvdeccClientHandler::sendCameraListDataToHMI(int loopsize)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::sendCameraListDataToHMI %d", loopsize));
   tCamData CD;
   vecCamDataToHmi.clear(); // clear and refill contents.

   for (int i = 1; i <= loopsize; i++)
   {
      ETG_TRACE_USR4(("CameraAvdeccClientHandler::-------------1st for loop %d", i));
      for (auto it : CameraList) // Pick from main camera list
      {
         ETG_TRACE_USR4(("CameraAvdeccClientHandler::------------2nd for loop %d", it.pos));
         if (i == it.pos)
         {
            // CD.pos = m_camSplitData[i].pos;
            // CD.srcNam = m_camSplitData[i].srcNam;
            // CD.camtextid = m_camSplitData[i].camtextid;
            vecCamDataToHmi.push_back(it);
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:: inside if condition"));
         }
      }
   }

   for (auto i : vecCamDataToHmi)
   {
      ETG_TRACE_USR4(("CameraAvdeccClientHandler::CameraList %d  %d  %s", i.pos, i.camtextid, i.srcNam.c_str()));
   }
   CameraMain::poGetInstance()->vOnReceiveCameraList(vecCamDataToHmi);
}


void CameraAvdeccClientHandler::requestCameraListDataFromHMI(int loopsize)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::sendCameraListDataToHMI %d", loopsize));
   vecCamDataToHmi.clear(); // clear and refill contents.

   // 3 CMP, but only 2 detected. The list request is put for 2 CMPs.
   // Pick 1st 6 analogue cameras, then ipcam of cmp1, cmp2, the split of cmp1, cmp2.
   // 123456789A B.C.D EFG-HIJ-KLM ==> 123456,BC,EFG-HIJ

   //usecase 1: 3 CMPs are configured. Connection status is for 1, 2 CMPs.
   if ((m_numberofCMPS == 3) && (loopsize == 2))
   {
      for (int i = 0; i < 6; i++)
      {
         vecCamDataToHmi.push_back(CameraList.at(i));
      }

      for (int k = 10; k < 12; k++)
      {
         vecCamDataToHmi.push_back(CameraList.at(k));
      }

      for (int j = 13; j < 19; j++)
      {
         vecCamDataToHmi.push_back(CameraList.at(j));
      }
   }   //usecase 2: 1 CMPs are configured. Connection status is for 1, 2 CMPs.
   else if (loopsize < m_numberofCMPS) //(1 < 2) or (1 < 3)    // Primary is detected or 2nd disconnected, we send only primary list. 1 < 1|2|3    2 < 2 | 3
   {
      for (auto it : CameraList) // Pick from main camera list
      {
         if (loopsize == it.pos)
         {
            vecCamDataToHmi.push_back(it);
         }
      }
   }
   else
   {
   }

   if (loopsize == m_numberofCMPS)  // (1 == 1) (2 == 2) (3 == 3)   // number of cmps is equal to number of request
   {
      for (auto it : CameraList) // Pick from main camera list
      {
         vecCamDataToHmi.push_back(it);
      }
   }

   for (auto i : vecCamDataToHmi)
   {
      ETG_TRACE_USR4(("CameraAvdeccClientHandler::CameraList %d  %d  %s", i.pos, i.camtextid, i.srcNam.c_str()));
   }
   CameraMain::poGetInstance()->vOnReceiveCameraList(vecCamDataToHmi);
}


void CameraAvdeccClientHandler::getAvdeccValue(std::string camSrc, int& avdeccValue)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::getAvdeccValue for camera source %s", camSrc.c_str()));
   if (mapCmpSrc_AvdeccValue.size() != 0)
   {
      std::map<std::string, int>::iterator itr = mapCmpSrc_AvdeccValue.find(camSrc);
      if (itr != mapCmpSrc_AvdeccValue.end())
      {
         avdeccValue = itr->second;
      }
      else
      {
      }
   }
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::getAvdeccValue for selected source is %d", avdeccValue));
}


void CameraAvdeccClientHandler::readCameraConfig()
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig"));

   if (_avRoutingParser != NULL)
   {
      ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig _avRoutingParser is not null"));
      // bool m_bParseState = _avRoutingParser->bParseXml();
      // ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig _avRoutingParser m_bParseState %d", m_bParseState));
      m_caminfo.clear();
      CameraList.clear();
      m_caminfo = _avRoutingParser->vecGetCamSrc();
      m_camSplitData = _avRoutingParser->vecGetSplitCamSrc();
      m_splitCaminfo = _avRoutingParser->vecGetSplitCamInfo();
      ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig m_splitCaminfo size %d", m_splitCaminfo.size()));
      if (m_splitCaminfo.size() > 0)
      {
         for (tU8 u8Index = 0 ; u8Index < m_splitCaminfo.size(); u8Index++)
         {
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split Pos is %d", m_splitCaminfo[u8Index].pos));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split name is %s", m_splitCaminfo[u8Index].name.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split view is %s",    m_splitCaminfo[u8Index].view.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split source_1 is %s", m_splitCaminfo[u8Index].source_1.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split source_2 is %s", m_splitCaminfo[u8Index].source_2.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split srcName is %s", m_splitCaminfo[u8Index].srcNam.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Split camTextid is %d", m_splitCaminfo[u8Index].camtextid));
         }
      }
      int numberOfCMPs = _avRoutingParser->vectorGetEntityID("CMP").size();
      ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig number of camports is %d", numberOfCMPs));
      m_numberofCMPS = numberOfCMPs;
      vPrepareAvdeccValuesForSplitCameras();   // this function will fill the avdecc values for each of the split cameras.
      if (m_camSplitData.size() > 0)
      {
         for (tU8 u8Index = 0 ; u8Index < m_camSplitData.size(); u8Index++)
         {
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig split Pos is %d", m_camSplitData[u8Index].pos));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig split srcName is %s", m_camSplitData[u8Index].srcNam.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig split camTextID is %d [%d]", u8Index, m_camSplitData[u8Index].camtextid));
         }
      }

      if (m_caminfo.size() > 0)
      {
         // Print for tracing
         for (tU8 u8Index = 0 ; u8Index < m_caminfo.size(); u8Index++)
         {
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig Pos is %d", m_caminfo[u8Index].pos));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig srcName is %s", m_caminfo[u8Index].srcNam.c_str()));
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:readCameraConfig camTextID is %d [%d]", u8Index, m_caminfo[u8Index].camtextid));
         }

         tU8 positionCMP = 0;
         tU8 u8Index = 0;

         switch (numberOfCMPs)
         {
            case ONE:
               positionCMP = getCamportIndex(1);
               fillDataInVector(positionCMP, 4);   // Pick 1st 4 analogue camera and add IP camera.
               break;

            case TWO:
               positionCMP = getCamportIndex(1);
               fillDataInVector(positionCMP, 3);     // Pick 1st 3 analogue camera.
               positionCMP = getCamportIndex(2);
               fillDataInVector(positionCMP, 4);   // Pick  4 analogue camera and add IP camera.
               break;

            case THREE:
               positionCMP = getCamportIndex(1);
               fillDataInVector(positionCMP, 3);      // Pick 1st 3 analogue camera.
               positionCMP = getCamportIndex(2);
               fillDataInVector(positionCMP, 3);  // Pick  3 analogue camera
               positionCMP = getCamportIndex(3);
               fillDataInVector(positionCMP, 4);  // Pick  4 analogue camera and add IP camera.

               break;
            default:
               break;
         }

         vCheckAndAddIPCamera(numberOfCMPs);
         vCheckAndAddSplitCamera(numberOfCMPs);
      }
   }
   vPrintCamInfo();
}


void CameraAvdeccClientHandler::vCheckAndAddIPCamera(int numberOfCMPs)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:vCheckAndAddIPCamera number of camports is %d", numberOfCMPs));
   tU8 positionCMP = 0;

   switch (numberOfCMPs)
   {
      case ONE:
         positionCMP = getIPCameraIndexFromCamport("CMP1_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);

         break;

      case TWO:
         positionCMP = getIPCameraIndexFromCamport("CMP1_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);
         positionCMP = getIPCameraIndexFromCamport("CMP2_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);

         break;
      case THREE:
         positionCMP = getIPCameraIndexFromCamport("CMP1_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);
         positionCMP = getIPCameraIndexFromCamport("CMP2_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);
         positionCMP = getIPCameraIndexFromCamport("CMP3_IPCAM");
         CL = m_caminfo[positionCMP];
         CameraList.push_back(CL);
         break;
      default:
         break;
   }
}


void CameraAvdeccClientHandler::fillDataInVector(int indexCMP, int loopSize)
{
   int u8Index = indexCMP;
   for (tU8 loop = 0 ; loop < loopSize; ++loop)
   {
      CL = m_caminfo[u8Index];
      CameraList.push_back(CL);
      ++u8Index;
   }
}


int CameraAvdeccClientHandler::getCamportIndex(int position)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:getCamportIndex %d", position));
   int positionIndex = 0;
   for (int index = 0; index < m_caminfo.size(); index++)
   {
      if (m_caminfo[index].pos == position)
      {
         positionIndex = index;
         break;
      }
   }
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:getCamportIndex index %d", positionIndex));
   return positionIndex;
}


int CameraAvdeccClientHandler::getIPCameraIndexFromCamport(std::string ipcamstr)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:getIPCameraIndexFromCamport find %s", ipcamstr));
   int positionIndex = 0;
   for (int index = 0; index < m_caminfo.size(); index++)
   {
      if (m_caminfo[index].srcNam == ipcamstr)
      {
         positionIndex = index;
         break;
      }
   }
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:getIPCameraIndexFromCamport found at %d", positionIndex));
   return positionIndex;
}


void CameraAvdeccClientHandler::sendCameraListOnHMIRequest()
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::sendCameraListOnHMIRequest, Vector size: %d", vecCamDataOnHmiRequest.size()));

   for (auto it : vecCamDataOnHmiRequest)
   {
      ETG_TRACE_USR4(("CameraAvdeccClientHandler::sendCameraListOnHMIRequest,%d -->  it.camtextid: %d, it.camSrcName: %s",
                      it.pos, it.camtextid, it.srcNam.c_str()));
   }
}


void CameraAvdeccClientHandler::vCheckAndAddSplitCamera(int numberOfCMPs)
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler:vCheckAndAddSplitCamera number of camports is %d", numberOfCMPs));
   tU8 positionCMP = 0;
   switch (numberOfCMPs)
   {
      case ONE:
         positionCMP = getCamportIndex(1);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick 3 split config from camport 1
         break;
      case TWO:
         positionCMP = getCamportIndex(1);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick 3 split config from camport 1
         positionCMP = getCamportIndex(2);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick 3 split config from camport 2
         break;
      case THREE:
         positionCMP = getCamportIndex(1);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick  3 split config from camport 1
         positionCMP = getCamportIndex(2);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick  3 split config from camport 2
         positionCMP = getCamportIndex(3);
         fillSplitDataInVector(positionCMP + 6, 3); // Pick  3 split config from camport 3
         break;
      default:
         break;
   }
}


tVoid CameraAvdeccClientHandler::vPrintCamInfo()
{
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo -------------> "));
   for (auto it : CameraList) // from xml
   {
      // ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo pos is %d", it.pos));
      // ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo srcNam is %s", it.srcNam.c_str()));
      // ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo camtextid is %d", it.camtextid));
      ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo PCS  %d  %d %s", it.pos, it.camtextid, it.srcNam.c_str()));
   }
   ETG_TRACE_USR4(("CameraAvdeccClientHandler::vPrintCamInfo <------------- "));
}


void CameraAvdeccClientHandler::fillSplitDataInVector(int indexCMP, int loopSize)
{
   tCamData CD;
   int u8Index = indexCMP;
   for (tU8 loop = 0 ; loop < loopSize; ++loop)
   {
      CD.pos = m_camSplitData[u8Index].pos;
      CD.srcNam = m_camSplitData[u8Index].srcNam;
      CD.camtextid = m_camSplitData[u8Index].camtextid;
      CameraList.push_back(CD);
      ++u8Index;
   }
}


int CameraAvdeccClientHandler::getSplitAvdeccValue(int position, std::string cameraSrc)
{
   int splitval = 0;
   for (tU8 u8Index = 0 ; u8Index < m_splitAvdeccinfo.size(); u8Index++)
   {
      if ((m_splitAvdeccinfo.at(u8Index).pos == position) && (m_splitAvdeccinfo.at(u8Index).name == cameraSrc))
      {
         splitval = m_splitAvdeccinfo.at(u8Index).avdeccValue;
      }
   }
   return splitval;
}


void CameraAvdeccClientHandler::vPrepareAvdeccValuesForSplitCameras()
{
   tCamPortAvdeccSplitInfo splitInfo;
   int avdeccValueSrc1 = 0;
   int avdeccValueSrc2 = 0;
   int splitAvdeccValue = 0;
   for (int l = 1; l <= m_numberofCMPS; l++)
   {
      for (int m = 0; m < 3; m++) // fpr now hardcoded to 3. will be changed to array size.
      {
         std::vector<std::string> vecSrNamesSplit =  _avRoutingParser->getSourceNamesForSplitView(strSplitCamSrcName[m], l);
         if (vecSrNamesSplit.size() > 0)
         {
            for (tU8 u8Index = 0 ; u8Index < vecSrNamesSplit.size(); u8Index++)
            {
               ETG_TRACE_USR4(("CameraAvdeccClientHandler:vPrepareAvdeccValuesForSplitCameras Split name src is %s", vecSrNamesSplit.at(u8Index).c_str()));
               getAvdeccValue(vecSrNamesSplit.at(u8Index).c_str(), avdeccValueSrc1);
            }
            getAvdeccValue(vecSrNamesSplit.at(0).c_str(), avdeccValueSrc1);
            getAvdeccValue(vecSrNamesSplit.at(1).c_str(), avdeccValueSrc2);
            splitAvdeccValue = avdeccValueSrc1 | avdeccValueSrc2;
            ETG_TRACE_USR4(("CameraAvdeccClientHandler:vPrepareAvdeccValuesForSplitCameras AV is %d | %d -> %d", avdeccValueSrc1, avdeccValueSrc2, splitAvdeccValue));
         }
         splitInfo.pos = l;
         splitInfo.name = strSplitCamSrcName[m];
         splitInfo.avdeccValue = splitAvdeccValue;
         m_splitAvdeccinfo.push_back(splitInfo);
      }
   }
   if (m_splitAvdeccinfo.size() > 0)
   {
      for (tU8 u8Index = 0 ; u8Index < m_splitAvdeccinfo.size(); u8Index++)
      {
         ETG_TRACE_USR4(("CameraAvdeccClientHandler:vPrepareAvdeccValuesForSplitCameras Split avdecc value is %d", m_splitAvdeccinfo.at(u8Index).pos));
         ETG_TRACE_USR4(("CameraAvdeccClientHandler:vPrepareAvdeccValuesForSplitCameras Split avdecc value is %s", m_splitAvdeccinfo.at(u8Index).name.c_str()));
         ETG_TRACE_USR4(("CameraAvdeccClientHandler:vPrepareAvdeccValuesForSplitCameras Split avdecc value is %d", m_splitAvdeccinfo.at(u8Index).avdeccValue));
      }
   }
}


}
}
