/* ***************************************************************************************
* FILE:          Renderer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Renderer.h is part of HMI-Base delivery
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_RENDERER_H
#define HMIBASE_RENDERER_H

#include "IRenderer.h"

namespace hmibase {

namespace alertdaemon {

struct display;
struct window;

class Renderer : public IRendererPlugin
{
   public:

      Renderer();
      virtual ~Renderer();

      static IHMIAlert_Daemon_Plugin& Create();

      /**
       * @brief Inititializes the plugin to be ready for accessing its data & interfaces.
       *
       * @return True, if initialization was successful.
       */
      virtual bool Init();

      /**
       * @brief Resets the plugin owned data.
       */
      virtual void Reset();

      /**
       * @brief Generic interface to trigger an action.
       *
       * @param actionId 32bit information to determine action.
       * @param actionData 32bit data of the action
       */
      virtual void Action(uint32_t /*actionId*/, uint32_t /*actionData*/) {};

      virtual bool update(const std::vector<std::string>& texts);

      /**
       * @brief Call the plugin's diagnosis interface, e.g. for dumping the current state.
       *
       * @param requestId 32bit information to transport details of the requests nature.
       */
      virtual void RequestCurrentStatus(uint32_t /*requestId*/) {};

   private:
      struct display* _display;
      struct window* _window;

   private: // prevents copy construction and assignment
      Renderer(const Renderer& other);
      Renderer& operator =(const Renderer& other);
};


}
}


#endif
