/* ***************************************************************************************
* FILE:          WindowInputEventHook.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WindowInputEventHook.cpp is part of HMI-Base widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "WindowInputEventHook.h"
#include "Widgets/generated/AllWidgetMessages.h"

#ifdef WIN32
#include "AppBase/Platform/Win32/WindowInputEventHook.h"
#endif

namespace hmibase {
namespace widget {
namespace util {

#ifdef WIN32
class MyHook : public hmibase::app::base::util::KeyHook
{
   public:
      virtual Courier::Message* OnKeyDown(WPARAM key) const
      {
         Courier::Message* lMsg = NULL;

         switch (key)
         {
            case 'E':
               lMsg = COURIER_MESSAGE_NEW(ListCustomAnimationReqMsg)(0, Courier::ItemId("Widgets#Animations#ItemEntryAnimation"), CLAPlay);
               break;
            case 'F':
               lMsg = COURIER_MESSAGE_NEW(ListCustomAnimationReqMsg)(0, Courier::ItemId("Widgets#Animations#ItemFastEntryAnimation"), CLAPlay);
               break;

            case 'R':
               lMsg = COURIER_MESSAGE_NEW(ListCustomAnimationReqMsg)(0, Courier::ItemId("Widgets#Animations#ItemEntryAnimation"), CLAHoldStart);
               break;
            case 'G':
               lMsg = COURIER_MESSAGE_NEW(ListCustomAnimationReqMsg)(0, Courier::ItemId("Widgets#Animations#ItemEntryAnimation"), CLAHoldEnd);
               break;
            case 'M':
               lMsg = COURIER_MESSAGE_NEW(ListMorphReqMsg)(7003/*LISTID_COVERFLOW*/, 1);
               //lMsg = COURIER_MESSAGE_NEW(ListCustomAnimationReqMsg)(0, Courier::ItemId("Widgets#Animations#CoverflowMorphAnimation"), CLAPlay);
               break;
            case 'N':
               lMsg = COURIER_MESSAGE_NEW(ListMorphReqMsg)(7003/*LISTID_COVERFLOW*/, 0);
               break;

            /////////////
            // pagewise scrolling
            /////////////
            case 'A':
               lMsg = COURIER_MESSAGE_NEW(ListChangeMsg)(0, ListChangePageUp, 1);
               break;

            case 'Z':
               lMsg = COURIER_MESSAGE_NEW(ListChangeMsg)(0, ListChangePageDown, 1);
               break;

            case 'W':
               lMsg = COURIER_MESSAGE_NEW(ListChangeMsg)(0, ListChangeSet, 50);
               break;

            case 'S':
            {
               ListMovementDetails details = { true, 1000, 2000 };
               lMsg = COURIER_MESSAGE_NEW(ListAnimatedChangeReqMsg)(0, ListChangePageUp, 1, details, Courier::AnimationAction::Start, Courier::ViewId(""), Courier::CompositePath(""), Courier::ItemId("Widgets#Animations#TestSyncAnimation"), Courier::AnimationProperties());
            }
            break;

            case 'X':
            {
               ListMovementDetails details = { true, 0, 3000 };
               lMsg = COURIER_MESSAGE_NEW(ListAnimatedChangeReqMsg)(0, ListChangePageDown, 1, details, Courier::AnimationAction::Start, Courier::ViewId(""), Courier::CompositePath(""), Courier::ItemId("Widgets#Animations#TestSyncAnimation"), Courier::AnimationProperties());
            }
            break;

            /////////////
            // Speed lockout
            /////////////
            case 'L':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutComplete);
               break;
            case 'D':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutDirNext);
               break;
            case 'U':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutDirPrev);
               break;
            case 'P':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutPageWise);
               break;
            case 'O':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutPageWiseNext);
               break;
            case 'J':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutPageWisePrev);
               break;
            case 'I':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutNone);
               break;
            case '9':
               lMsg = COURIER_MESSAGE_NEW(LockOutMsg)(0, LockOutFixMovement);
               break;

            /////////////
            // Expanding/collapsing items
            /////////////
            case '1':
            {
               static FeatStd::UInt8 index = 0;
               lMsg = COURIER_MESSAGE_NEW(ListItemExpandReqMsg)(0, index, true);
               (++index) %= 6;
               break;
            }
            case '2':
            {
               static FeatStd::UInt8 index = 0;
               lMsg = COURIER_MESSAGE_NEW(ListItemExpandReqMsg)(0, index, false);
               (++index) %= 6;
               break;
            }

            /////////////
            // Remove Grid Items
            /////////////
            case '3':
               lMsg = COURIER_MESSAGE_NEW(ButtonReactionMsg)(Courier::ViewId(""), Courier::Identifier(), 0, enRelease, 0);
               break;

            default:
               break;
         }

         return lMsg;
      }

      virtual Courier::Message* OnKeyUp(WPARAM key) const
      {
         Courier::Message* msg = NULL;

         return msg;
      }
};


::hmibase::app::base::util::KeyHook* WindowInputEventHook::_hook = NULL;

#endif
WindowInputEventHook& WindowInputEventHook::GetInstance()
{
   static WindowInputEventHook hook;
   return hook;
}


WindowInputEventHook::WindowInputEventHook()
{
#ifdef WIN32
   _hook = new MyHook;
#endif
}


WindowInputEventHook::~WindowInputEventHook()
{
#ifdef WIN32
   if (_hook)
   {
      delete _hook;
   }
#endif
}


void WindowInputEventHook::Initialize()
{
#ifdef WIN32
   hmibase::app::base::WindowInputEventHook::RegisterKeyHook(WindowInputEventHook::_hook);
#endif
}


}
}


}
