/* ***************************************************************************************
* FILE:          WidgetDefaults.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetDefaults.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_WIDGET_DEFAULTS_H
#define HMIBASE_WIDGET_DEFAULTS_H

#include <Widgets/2D/Text/generated/TextWidget2DTypes.h>

namespace hmibase {
namespace widget {

/*
* Provides support to change default values in HmiBase widgets.
* The default value of a property in SceneComposer should be the same as the value in the widget library at runtime.
* To change a default value in SceneComposer set an environment variable.
* To change a default value at runtime call the setter from this class.
*/
class WidgetDefaults
{
   public:
      typedef ::hmibase::widget::text::enDirection::Enum TextDirectionType;
      static TextDirectionType GetTextDirection()
      {
         return _textDirection;
      }

      /*
      * Sets default text direction used by text widget.
      * To have this setter called in Scene Composer one must set the environment variable HMIBASE_WIDGET_TEXT_DEFAULT_DIRECTION with value from Implicit, LeftToRight, RightToLeft, Culture, Node, Legacy.
      */
      static void SetTextDirection(TextDirectionType textDirection);

      static bool GetTextCultureDependentAlignment()
      {
         return _textCultureDependentAlignment;
      }

      /*
      * Sets default text culture dependent alignment used by text widget.
      * To have this setter called in Scene Composer one must set the environment variable HMIBASE_WIDGET_TEXT_DEFAULT_CULTURE_DEPENDENT_ALIGNMENT with value from true, false, 1 or 0.
      */
      static void SetTextCultureDependentAlignment(bool textCultureDependentAlignment);

#ifdef WIN32
      static bool InitSCHost();
#endif

   private:
      static TextDirectionType _textDirection;
      static bool _textCultureDependentAlignment;
};


}
}


#endif
