/* ***************************************************************************************
* FILE:          SharedTimerManager.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SharedTimerManager.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(hmibase_SharedTimerManager_h)
#define hmibase_SharedTimerManager_h

#include <map>


namespace Util {
class Timer;
}


namespace hmibase {
namespace widget {
namespace util {


/*****************************************************************************/
/*
* Provides support to share timers identified by numerical ids.
* A typical use case is to have multiple animation widgets running which should all update in the same time.
* This can be done if those widgets would use get the notifications from the same timer.
*/
class SharedTimerManager
{
   public:
      /******************************************************************************/
      SharedTimerManager();
      ~SharedTimerManager();

      /******************************************************************************/
      /* Checks if the specified timer is the same as the one stored internally for a specific index. */
      bool matches(FeatStd::Int index, const Util::Timer& timer) const;

      /*****************************************************************************/
      /*
      * Acquire the timer for the specified index and starts it if not already started if timeout is greater than 0.
      * If no timer exists for that index it will be created, otherwise its reference count is incremented.
      */
      bool acquire(FeatStd::Int index, FeatStd::UInt32 timeout);

      /******************************************************************************/
      void release(FeatStd::Int index);

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(SharedTimerManager);

      /******************************************************************************/
      struct TimerInfo
      {
         TimerInfo() : Timer(NULL), RefCount(0) {}
         ~TimerInfo()
         {
            Timer = NULL;
         }

         Util::Timer* Timer;
         FeatStd::Int RefCount;
      };
      typedef std::map<FeatStd::Int, TimerInfo> TimersType;
      TimersType _timers;
};


}
}


}


#endif  // hmibase_SharedTimerManager_h
