/* ***************************************************************************************
* FILE:          EffectUtils.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EffectUtils is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef hmibase__widget_utils_effectutils_h
#define hmibase__widget_utils_effectutils_h

#include <Candera/Engine2D/Property/ColorProperty.h>


namespace Candera {
class Effect2D;
class Node2D;

class GlOutlineEffect;
class GlDropShadowEffect;
class GlLinearGradientBrush;
class GlRadialGradientBrush;
}


namespace hmibase {
namespace widget {
namespace utils {

class EffectUtils
{
   public:
      template <typename TEffect>
      static TEffect* getEffect(Candera::Effect2D* combinedEffect);

      struct colorid
      {
         enum ENUM { None, Outline, DropShadow };
      };

      static Candera::ColorProperty* getColorProperty(Candera::Node2D* node, colorid::ENUM id = colorid::None);
      static Candera::ColorProperty* getColorProperty(Candera::Effect2D* effect, colorid::ENUM id = colorid::None);

      typedef Candera::Color ColorType;

      static bool setColor(Candera::Node2D* node, const ColorType& color, colorid::ENUM id = colorid::None);
      static ColorType getColor(const Candera::Node2D* node, colorid::ENUM id = colorid::None);
      static void copyColor(const Candera::Node2D* source, Candera::Node2D* destination, colorid::ENUM id = colorid::None);

   private:
      EffectUtils();
};


template<>
Candera::GlOutlineEffect* EffectUtils::getEffect<Candera::GlOutlineEffect>(Candera::Effect2D* combinedEffect);
template<>
Candera::GlDropShadowEffect* EffectUtils::getEffect<Candera::GlDropShadowEffect>(Candera::Effect2D* combinedEffect);
template<>
Candera::GlLinearGradientBrush* EffectUtils::getEffect<Candera::GlLinearGradientBrush>(Candera::Effect2D* combinedEffect);
template<>
Candera::GlRadialGradientBrush* EffectUtils::getEffect<Candera::GlRadialGradientBrush>(Candera::Effect2D* combinedEffect);


/*****************************************************************************/
template <typename TEffect>
TEffect* EffectUtils::getEffect(Candera::Effect2D* combinedEffect)
{
   if (combinedEffect != NULL)
   {
      TEffect* effect = NULL;

      //effect = Candera::Dynamic_Cast<TEffect*>(combinedEffect->GetBrushEffect2D());
      //if (effect != NULL)
      //{
      //   return effect;
      //}

      for (FeatStd::UInt8 i = 0; i < combinedEffect->GetInPlaceEffect2DCount(); ++i)
      {
         effect = Candera::Dynamic_Cast<TEffect*>(combinedEffect->GetInPlaceEffect2D(i));
         if (effect != NULL)
         {
            return effect;
         }
      }

      //effect = Candera::Dynamic_Cast<TEffect*>(combinedEffect->GetBlendEffect2D());
      //if (effect != NULL)
      //{
      //   return effect;
      //}
   }

   return NULL;
}


}
}


}

HMIBASE_DEPRECATED_TYPE_ALIAS(ColorEffectUtils, hmibase::widget::utils::EffectUtils)

#endif
