/* ***************************************************************************************
* FILE:          IBlurShader.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IBlurShader is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_IBlurShader_h__
#define BlurWidgetCommonSpace_IBlurShader_h__

#include "BlurUtilsCommon.h"
#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/Engine3D/ShaderParamSetters/ShaderParamSetter.h>
#include <Candera/Engine3D/ShaderParamSetters/GenericShaderParamSetter.h>
#include <string>
#include <vector>

namespace hmibase {
namespace widget {
namespace blur {

typedef FeatStd::MemoryManagement::SharedPointer<Candera::Shader> SharedPointerShaderType;
typedef FeatStd::MemoryManagement::SharedPointer<Candera::ShaderParamSetter> SharedPointerParamSetterType;

class IBlurShader
{
   public:
      virtual ~IBlurShader() {};

      virtual void SetTextureWidth(Candera::Int32 inWidth) = 0;

      virtual void SetTextureHeight(Candera::Int32 inHeight) = 0;

      virtual void SetSigma(Candera::Float inSigma) = 0;

      virtual void SetRadius(Candera::Int32 inRadius) = 0;

      virtual void SetDarken(Candera::Float inDarken[4]) = 0;

      virtual void SetBlurMaskRectangle(Candera::Rectangle inRect, bool inKeepFrameBuffer, bool inMaskEnabled) = 0;

      virtual void SetMaskTextureUnit(Candera::Int32 maskUnit, bool inCombineWithMask) = 0;

      virtual void SetSourceTextureUnit(Candera::Int32 sourceUnit) = 0;

      virtual bool HasValidShader() = 0;

      virtual bool HasValidParams() = 0;

      virtual SharedPointerShaderType GetShader() = 0;

      virtual SharedPointerParamSetterType GetShaderParams() = 0;
};


}
}


}
#endif // ifndef BlurWidgetCommonSpace_IBlurShader_h__
