/* ***************************************************************************************
* FILE:          BlurShaderBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusGroupWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetCommonSpace_BlurShaderBase_h__
#define BlurWidgetCommonSpace_BlurShaderBase_h__

#include "Widgets/utils/Blur/IBlurShader.h"

namespace hmibase {
namespace widget {
namespace blur {

class BlurShaderBase : public IBlurShader
{
   public:
      virtual ~BlurShaderBase() {};

      virtual void SetTextureWidth(Candera::Int32 inWidth)
      {
         m_textureWidth = inWidth;
      }

      virtual void SetTextureHeight(Candera::Int32 inHeight)
      {
         m_textureHeight = inHeight;
      }

      virtual void SetSigma(Candera::Float inSigma)
      {
         m_sigma = inSigma;
      }

      virtual void SetRadius(Candera::Int32 inRadius)
      {
         m_radius = inRadius;
      }

      virtual void SetDarken(Candera::Float inDarken[4]);

      virtual void SetBlurMaskRectangle(Candera::Rectangle inRect, bool inKeepFrameBuffer, bool inMaskEnabled);

      virtual void SetMaskTextureUnit(Candera::Int32 maskUnit, bool inCombineWithMask);

      virtual void SetSourceTextureUnit(Candera::Int32 sourceUnit);

      virtual bool HasValidShader() = 0;

      virtual bool HasValidParams() = 0;

      std::string GenerateMaskUnformCode() const;

      std::string GenerateMaskDecisionCode() const;

      std::string GenerateMaskFragColorCode() const;

      virtual SharedPointerShaderType GetShader() = 0;

      virtual SharedPointerParamSetterType GetShaderParams() = 0;

   protected:
      BlurShaderBase();

      virtual void UpdateGuidString(); // Fills m_guidString with member values. has to be overridden in each derived class. Has to be called FIRST in overriding method.
      FeatStd::Internal::Guid MakeGuid(); // Creates a valid version 3 GUID from the  m_guidString using the m_guidStringBase as namespace.

      Candera::Int m_textureWidth;
      Candera::Int m_textureHeight;
      Candera::Float m_sigma;
      Candera::Int32 m_radius;
      Candera::Float m_darken[4];
      Candera::Float m_bitmapMaskPosition[4];

      std::string m_varyingTexCoord;
      std::string m_uniformTexSampler;
      std::string m_uniformDarken;
      std::string m_uniformBlurRadius;
      std::string m_uniformBitmapMaskPosition;
      std::string m_blurAccumulator;
      std::string m_maskTextureUnit;
      std::string m_sourceTextureUnit;
      bool m_combineWithMask;
      bool m_keepFrameBuffer;

      std::string m_guidStringBase; //valid GUID that will be used as namespace to generate a valid guid from text.
      std::string m_guidString; //string that contains the values of all relevant members.
};


}
}


}   //namespace
#endif  // BlurWidgetCommonSpace_BlurShaderBase_h__
