/* ***************************************************************************************
* FILE:          BlurRenderer.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurRenderer is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "widget2D_std_if.h"
#include "BlurRenderer.h"
#include "IBlurShader.h"

#ifdef COURIER_ENHANCED_ENABLED

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_BLUR
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/BlurRenderer.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace blur {

using namespace Candera;
using namespace Courier;


bool BlurRenderer::AddGdu(GraphicDeviceUnit* inGdu)
{
   if (NULL != inGdu)
   {
      Gdu* gduObj = FEATSTD_NEW(Gdu)(inGdu, mGDU.Size());
      FEATSTD_LINT_NEXT_EXPRESSION(774, "allocation may fail")

      if ((0 != gduObj) && mGDU.Add(gduObj))
      {
         gduObj->Log();

         if (mRenderConfiguration.ShallLoadAllRenderTargetsAtStartup())
         {
            Gdu* lookupGdu = GetGdu(gduObj->GetRenderTarget());

            if ((0 != lookupGdu) && (!lookupGdu->IsLoaded()))
            {
               EnableLayer(true, lookupGdu->GetRenderTarget(), true);
            }
         }
         return true;
      }
   }
   return false;
}


bool BlurRenderer::LoadGdu(GraphicDeviceUnit* inGdu)
{
   if (NULL != inGdu)
   {
      Gdu* lookupGdu = GetGdu(inGdu->ToRenderTarget3D());
      if ((0 != lookupGdu) && (!lookupGdu->IsLoaded()))
      {
         EnableLayer(true, lookupGdu->GetRenderTarget(), true);
      }
      return true;
   }
   return false;
}


bool BlurRenderer::RemoveGdu(GraphicDeviceUnit* inGdu)
{
   bool result = false;

   if (NULL != inGdu)
   {
      for (Candera::Int i = 0; i < mGDU.Size(); i++)
      {
         Gdu* gdu = mGDU[i];

         if (gdu != 0)
         {
            if (inGdu->ToRenderTarget3D() == gdu->GetRenderTarget())
            {
               if (mGDU.Remove(i))
               {
                  i = Math::Maximum(i - 1, 0);
                  result = true;
               }
               else
               {
                  ETG_TRACE_ERR(("Removing the GDU from GDU vector failed!"));
               }
            }
         }
      }
   }
   return result;
}


}
}


}

#endif  //#ifdef COURIER_ENHANCED_ENABLED
