/* ***************************************************************************************
* FILE:          BlurCameraSetter.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusGroupWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurCameraSetter_BlurCameraSetter_h__
#define BlurCameraSetter_BlurCameraSetter_h__


namespace hmibase {
namespace widget {
namespace blur {
class WindowRect;

void GetViewport(Candera::Camera2D const* camera, WindowRect& outViewport);
void GetViewport(Candera::Camera2D const* camera, Candera::RenderTarget2D const* renderTarget, WindowRect& outViewport);
void GetViewport(Candera::Camera const* camera, WindowRect& outViewport);
void GetViewport(Candera::Camera const* camera, Candera::RenderTarget3D const* renderTarget, WindowRect& outViewport);

void SetViewport(Candera::Camera2D* camera, WindowRect& inViewport);
void SetViewport(Candera::Camera* camera, WindowRect& inViewport);

void GetScissor(Candera::Camera2D const* camera, WindowRect& outScissor);
void GetScissor(Candera::Camera const* camera, WindowRect& outScissor);

void SetScissor(Candera::Camera2D* camera, WindowRect& inScissor);
void SetScissor(Candera::Camera* camera, WindowRect& inScissor);

void CopyCameraSettings(Candera::Camera2D const* source, Candera::Camera* target, bool copyViewport, bool copyScissor);
void CopyCameraSettings(Candera::Camera const* source, Candera::Camera* target, bool copyViewport, bool copyScissor);
}


}
}


#endif
