/* ***************************************************************************************
* FILE:          WidgetSetCore.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetSetCore is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include <Candera/Environment.h>
#include <CanderaWidget/WidgetBase/WidgetMetaInfo.h>
#include <CanderaWidget/Widget.h>

// 1000 fr83hi: 2014-10-08 initial value, first WidgetSet with Version support
// 1001 fr83hi: 2014-11-06 FallbackList renamed to FlexList
// 1002 fr83hi: 2015-11-06 CGI 2.11.2 delivery
// 2001 fr83hi: 2015-02-12 restructure
// 2002 fr83hi: 2015-02-14 new reworked interface button/text widgets
// 2003 fr83hi: 2015-03-19 CGI 2.11.3 delivery
// 2004 fet2hi: 2015-05-27 removed ImageWidget, BusyIndicator, RadioButton, ToggleButton, RichTextBase.
// 2005 fr83hi: 2015-06-08 cleanup using namespace in headerfiles; add DirectTexture3D.
// 2006 fet2hi: 2015-07-01 remove ODR and LaneGuidance
// 2007 fet2hi: 2015-08-19 Flexlist delivery 7, Flexlist delivery 8
// 2008 fet2hi: 2015-08-26 ImageWidget2D, LaneGuidanceWidget2D, ODRWidget2D removed, ClockWidget2D added
// 2009 fr83hi: 2015-08-31 Flexlist delivery 9b
// 2010 fr83hi: 2015-09-16 CGI2.12, reworked TextWidget2D, remove of TextEffectWidget2D
// 2011 fet2hi: 2015-09-23 add SolidColorEffectWidget2D
// 2012 fr83hi: 2015-09-28 add TextExtensionWidget2D
// 2013 fr83hi: 2015-09-28 Flexlist delivery 10 (fixed version from 28.09.2015)
// 2014 fr83hi: 2015-09-02 Flexlist delivery bugfixes and stabi for fixelwise scrolling
// 2015 fr83hi: 2015-10-05 ScrollableText rendering in blocks and fix memory corruption in Scenecomposer
// 2016 fr83hi: 2015-10-05 reenable widget version validation in AppEnvironment::CheckAssetDisplayConfiguration
// 2017 fet2hi: 2015-10-16 add ButtonTextScrollWidget2D widget and FallbackStrategyEnabled property in ButtonImageWidget2D
// 2018 fr83hi: 2015-10-19 TextWidget2D with changed scrolling properties
// 2019 fet2hi: 2016-03-10 add NodeControlWidget2D, change widget categories, make Flex widgets deprecated (same widgets without the Flex prefix are available)
// 2020 fet2hi: 2016-03-29 add ColorEffectWidget2D
// 2020 fr83hi: 2016-05-12 VideoContainerWidget2D and SequenceImageWidget2D removed
// 2020 fr83hi: 2016-05-25 Add OPS and TwoDimensionSlider ( for further development )
// 2020 fet2hi: 2016-08-04 Add ButtonAnimationWidget2D
// 2020 fr83hi: 2016-08-05 add ScrollBarButtonWidget2D as replacement for FlexScrollbarWidget2D
// 2020 fr83hi: 2016-08-09 split WidgetSet in different parts

#define HMI_BASE_WIDGET_VERION   2020


typedef std::vector<Candera::MetaInfo::WidgetSetMetaInfo*> WidgetSetEntryVectorType;

class WidgetSetCore : public Candera::MetaInfo::WidgetSetMetaInfo
{
   private:
      static WidgetSetEntryVectorType _widgetSets;    // array with widgetset parts

      FeatStd::UInt GetNumberOfWidgetSets() const;
      Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet(FeatStd::UInt index) const;
   public:
      WidgetSetCore();

      static void RegisterWidgetSet(Candera::MetaInfo::WidgetSetMetaInfo* p);

      virtual Candera::MetaInfo::WidgetMetaInfo* LookupItem(const Candera::Char* name) const;
      virtual Candera::MetaInfo::WidgetMetaInfo* GetItem(FeatStd::Int32 idx) const;
      virtual FeatStd::Int32 GetItemCount() const;
      virtual Candera::UInt32 GetHash() const;

      CdaVersion(HMI_BASE_WIDGET_VERION)
};


void RegisterWidgetSets(void);    // As AutoRegisterSelf doesn't work factory calls for registration


#define CdaWidgetSetPartDefinitionBegin(name) \
   typedef struct name : public Candera::MetaInfo::WidgetSetMetaInfo \
   { \
      _CdaMetaInfoCtors(name, name, Candera::MetaInfo::WidgetSetMetaInfo)


#define CdaWidgetSetPartDefinitionEnd(name) \
   } WidgetSetArray##name; \
   \
   Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_##name() \
   { \
      static WidgetSetArray##name _widgetSet; \
      return &_widgetSet; \
   }

#define WidgetSetAutoRegisterSelf(name)

#define no_WidgetSetAutoRegisterSelf(name) \
volatile class AutoRegister_##name \
{  \
public:  \
   AutoRegister_##name()   \
   {  \
      RegisterWidgetSet(GetWidgetSet_##name()); \
   }  \
}; \
static AutoRegister_##name dummyReg##name;
