/* ***************************************************************************************
* FILE:          TextWidgetFinderCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextWidgetFinderCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "TextWidgetFinderCallback.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/2D/Text/TextWidget2D.h"
#include "hmibase/util/StringUtils.h"
#include <FeatStd/Util/String.h>

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TextWidgetFinderCallback.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace trace {

TextWidgetFinderCallback::TextWidgetFinderCallback(): _textName(""), _widget2D(NULL)
{
}


// ------------------------------------------------------------------------
TextWidgetFinderCallback::TextWidgetFinderCallback(const FeatStd::Char* textName): _widget2D(NULL)
{
   _textName = textName;
}


// ------------------------------------------------------------------------
bool TextWidgetFinderCallback::CheckWidget(Candera::Widget2D* widget)
{
   //BaseWidget2D *baseWidget = dynamic_cast<BaseWidget2D*>(widget);
   if (widget != NULL)
   {
      TextWidget2D* wt = dynamic_cast<TextWidget2D*>(widget);

      if ((wt != 0) && !_textName.empty())
      {
         SECURE_FEATSTD_STRING_ACCESS_BEGIN(wt->GetText());
         if (! strcmp(_textName.c_str(), wt->GetText().GetCString()))
         {
            if (widget->GetNode()->IsEffectiveRenderingEnabled())
            {
               _widget2D = widget;
               SECURE_FEATSTD_STRING_ACCESS_BEGIN(wt->GetText());
               ETG_TRACE_FATAL(("Searching Text [%100s] is found", wt->GetText().GetCString()));
               SECURE_FEATSTD_STRING_ACCESS_END();
               return true;
            }
            else
            {
               return false;
            }
         }
         SECURE_FEATSTD_STRING_ACCESS_END();
      }
   }
   return false;
}


} // namespace trace
}


}
