/* ***************************************************************************************
* FILE:          TextIdWidgetFinderCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextIdWidgetFinderCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef TEXT_ID_WIDGET_FINDER_CALLBACK_H_
#define TEXT_ID_WIDGET_FINDER_CALLBACK_H_

#include "View/IMessageSystem.h"

namespace hmibase {
namespace widget {
namespace trace {
/** TextIdWidgetFinderCallback is used to get a callback from all the widgets in the current scene and
Check is it text widget.
*/
class TextIdWidgetFinderCallback : public WidgetCheckCallback
{
   private:
      std::string _translatedTextId;
      Candera::Widget2D* _widget2D;

   public:
      TextIdWidgetFinderCallback();
      TextIdWidgetFinderCallback(const FeatStd::Char* textName);
      /**
      Prints the widget name, based on the received input parameter (Candera::Widget2D*)
      */
      virtual bool CheckWidget(Candera::Widget2D* widget);

      Candera::Widget2D* GetTextWidget2D()
      {
         return _widget2D;
      }
};


}	// namespace_trace
}	// namespace_hmibase
}	// namespace_hmibase

#endif // TEXT_ID_WIDGET_FINDER_CALLBACK_HPP
