/* ***************************************************************************************
 * FILE:          TextIdWidgetFinderCallback.cpp
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  TextIdWidgetFinderCallback.cpp is part of HMI-Base framework Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#include "sys_std_if.h"

#include "TextIdWidgetFinderCallback.h"

#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/2D/Text/TextWidget2D.h"
#include "hmibase/util/StringUtils.h"
#include <FeatStd/Util/String.h>

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TextIdWidgetFinderCallback.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace trace {

TextIdWidgetFinderCallback::TextIdWidgetFinderCallback(): _translatedTextId(""), _widget2D(NULL)
{
}


// ------------------------------------------------------------------------
TextIdWidgetFinderCallback::TextIdWidgetFinderCallback(const FeatStd::Char* textName): _widget2D(NULL)
{
   _translatedTextId = textName;
}


// ------------------------------------------------------------------------
bool TextIdWidgetFinderCallback::CheckWidget(Candera::Widget2D* widget)
{
   //BaseWidget2D *baseWidget = dynamic_cast<BaseWidget2D*>(widget);
   Candera::WidgetBase* widgetBase = dynamic_cast<Candera::WidgetBase*>(widget);

   if (widgetBase != 0)
   {
      TextWidget2D* wt = dynamic_cast<TextWidget2D*>(widgetBase);
      if (wt != NULL)
      {
         Candera::MetaInfo::WidgetMetaInfo* metaInfo = widgetBase->GetMetaInfo();
         if (metaInfo != 0)
         {
            char buffer[100];
            Candera::MetaInfo::PropertyMetaInfo<Candera::WidgetBase>* propertyMetaInfo = metaInfo->LookupItem("Text");

            if (0 == propertyMetaInfo)
            {
               ETG_TRACE_FATAL(("NULL pointer : propertyMetaInfo"));
            }
            else
            {
               if (!propertyMetaInfo->Get(widgetBase, buffer, 100))
               {
                  //ETG_TRACE_FATAL(("PropertyName = %100s, Property value is failed to transform to a string buffer", propertyName));
               }
               else
               {
                  if (!_translatedTextId.empty())
                  {
                     if (! strcmp(_translatedTextId.c_str(), buffer))
                     {
                        if (widget->GetNode()->IsEffectiveRenderingEnabled())
                        {
                           _widget2D = widget;
                           ETG_TRACE_FATAL(("Searching TextID [%100s] is found", buffer));
                           return true;
                        }
                        else
                        {
                           return false;
                        }
                     }
                  }
                  memset(buffer, 0, sizeof(buffer));
               }
            }
         }
      }
   }
   return false;
}


} // namespace trace
}


}
