/* ***************************************************************************************
* FILE:          PrintTextInListCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PrintTextInListCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"
#include "PrintTextInListCallback.h"
#include "Widgets/2D/List/ListWidget2D.h"
#include "PrintAllVisibleTextCallback.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/PrintTextInListCallback.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace trace {
// ------------------------------------------------------------------------
bool PrintTextInListCallback::CheckWidget(Candera::Widget2D* widget)
{
   if (widget != NULL)
   {
      ListWidget2D* list = dynamic_cast<ListWidget2D*>(widget);

      if (list != 0)
      {
         const FeatStd::Char* name = list->GetLegacyName();

         if (_dataPtr != 0)
         {
            //ETG_TRACE_FATAL(("Listing all Texts within ListWidget start"));
            *(_dataPtr) += "Listing all Texts within ListWidget START\n";
            //ETG_TRACE_FATAL(("ListWidgetName = %100s, ListId = %d", (name != 0) ? name : "", list->GetListId()));
            *(_dataPtr) += "ListWidgetName = ";
            *(_dataPtr) += (name != 0) ? name : "";
            *(_dataPtr) += ", ListId = ";
            std::stringstream ss;
            ss << list->GetListId();
            *(_dataPtr) += ss.str();
            *(_dataPtr) += "\n";

            PrintAllVisibleTextCallback callback(_dataPtr);
            WidgetCheckReqMsg msgToFindTextWidgets(&callback);
            list->OnMessage(msgToFindTextWidgets);
            //ETG_TRACE_FATAL(("Listing all Texts within ListWidget end"));
            *(_dataPtr) += "Listing all Texts within ListWidget END\n";
            *(_dataPtr) += "-----------------------------------------\n";
            //ETG_TRACE_FATAL(("-----------------------------------------"));
         }
      }
   }
   return false;
}


} // namespace trace
}


}
