/* ***************************************************************************************
* FILE:          PrintAllVisibleTextCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PrintAllVisibleTextCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef PRINT_ALL_VISIBLE_TEXT_CALLBACK_H_
#define PRINT_ALL_VISIBLE_TEXT_CALLBACK_H_

#include "View/IMessageSystem.h"


namespace hmibase {
namespace widget {
namespace trace {
class PrintAllVisibleTextCallback : public WidgetCheckCallback
{
   public:
      /**
      Prints the Text present in all the visible TextWidgets in the given container (container can be a view or ListWidget)
      */
      virtual bool CheckWidget(Candera::Widget2D* widget);

      // make it private so nobody can use it
      PrintAllVisibleTextCallback& operator=(const PrintAllVisibleTextCallback& rhs);

      PrintAllVisibleTextCallback()
      {
         _skipReadingMetaInfo = false;
         _dataPtr = 0;
      }

      PrintAllVisibleTextCallback(std::string* dataPtr)
      {
         _dataPtr = dataPtr;
         _skipReadingMetaInfo = false;
      }

   private:
      Candera::String _textData;
      bool _skipReadingMetaInfo;
      std::string* _dataPtr;
};


}	// namespace_trace
}


}	// namespace_hmibase

#endif // PRINT_ALL_VISIBLE_TEXT_CALLBACK_H_
