/* ***************************************************************************************
* FILE:          PrintAllVisibleTextCallback.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PrintAllVisibleTextCallback.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "sys_std_if.h"

#include "PrintAllVisibleTextCallback.h"

#include "Widgets/2D/Text/TextWidget2D.h"
#include "Widgets/2D/ScrollableText/ScrollableTextWidget2D.h"
#include "Widgets/2D/TextArea/TextAreaWidget2D.h"

#include "hmi_trace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/PrintAllVisibleTextCallback.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace trace {

#define MAX_CHAR_COUNT 200
#define TEXT_PROPERTY "Text"


// ------------------------------------------------------------------------
bool PrintAllVisibleTextCallback::CheckWidget(Candera::Widget2D* w)
{
   if (w != NULL)
   {
      bool result = false;
      if (dynamic_cast<TextWidget2D*>(w))
      {
         _textData = static_cast<TextWidget2D*>(w)->GetText();
         result = true;
      }
      else if (dynamic_cast<ScrollableTextWidget2D*>(w))
      {
         _textData = static_cast<ScrollableTextWidget2D*>(w)->GetText();
         // Here the textId is not read. Only the retrieved text is displayed.
         if (_textData.GetCharCount() != 0)
         {
            BaseWidget2D* bw = dynamic_cast<BaseWidget2D*>(w);
            if ((bw != 0) && (bw->GetNode() != 0) && (bw->GetNode()->IsEffectiveRenderingEnabled()))
            {
               if (_dataPtr != 0)
               {
                  SECURE_FEATSTD_STRING_ACCESS_BEGIN(_textData);
                  //ETG_TRACE_FATAL(("WidgetName = '%50s', Text = '%150s'",
                  //bw->GetLegacyName(), _textData.GetCString()));
                  (*_dataPtr) += "widgetName = ";
                  (*_dataPtr) += "'";
                  (*_dataPtr) += bw->GetLegacyName();
                  (*_dataPtr) += "', Text = ";
                  (*_dataPtr) += _textData.GetCString();
                  SECURE_FEATSTD_STRING_ACCESS_END();
               }
            }
         }
         result = true;
         _skipReadingMetaInfo = true; // to avoid crash which was observed in FeatStd::Internal::Generic::GenericString::Copy(FeatStd::Char *to, const FeatStd::Char *from). When reading a huge data from scrollableTextWidget
      }
      else if (dynamic_cast<TextAreaWidget2D*>(w))
      {
         _textData = static_cast<TextAreaWidget2D*>(w)->GetText();
         result = true;
      }

      if (result && !_skipReadingMetaInfo)
      {
         BaseWidget2D* bw = dynamic_cast<BaseWidget2D*>(w);

         if ((bw != 0) && (bw->GetNode() != 0) && (bw->GetNode()->IsEffectiveRenderingEnabled()))
         {
            Candera::MetaInfo::WidgetMetaInfo* metaInfo = w->GetMetaInfo();

            if (metaInfo != 0)
            {
               Candera::MetaInfo::PropertyMetaInfo<Candera::WidgetBase>* propertyMetaInfo = metaInfo->LookupItem(TEXT_PROPERTY);
               if (propertyMetaInfo != 0 && (strcmp(propertyMetaInfo->GetName(), TEXT_PROPERTY) == 0)) // additional check to verify if the metainfo is related to "Text" property
               {
                  char buffer[MAX_CHAR_COUNT];
                  memset(buffer, '\0', sizeof(buffer));

                  if (propertyMetaInfo->Get(w, buffer, sizeof(buffer)))
                  {
                     if (_dataPtr != 0)
                     {
                        SECURE_FEATSTD_STRING_ACCESS_BEGIN(_textData);

                        //ETG_TRACE_FATAL(("WidgetName = '%25s', Text = '%100s', TextId = '%75s'",
                        //bw->GetLegacyName(), _textData.GetCString(), buffer));
                        (*_dataPtr) += "WidgetName = ";
                        (*_dataPtr) += "'";
                        (*_dataPtr) += bw->GetLegacyName();
                        (*_dataPtr) += "', Text = '";
                        (*_dataPtr) += _textData.GetCString();
                        (*_dataPtr) += "', ";
                        (*_dataPtr) += "TextId = ";
                        (*_dataPtr) += buffer;
                        (*_dataPtr) += "\n";

                        SECURE_FEATSTD_STRING_ACCESS_END();
                     }
                     memset(buffer, '\0', sizeof(buffer));
                  }
               }
            } // ![metaInfo]
         }
      }
      _skipReadingMetaInfo = false;
   }
   return false;
}


} // namespace trace
}  // namespace widget
}  // namespace hmibase
