/* ***************************************************************************************
* FILE:          ListWidgetFinderCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidgetFinderCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef LISTWIDGET_FINDER_CALLBACK_H_
#define LISTWIDGET_FINDER_CALLBACK_H_

#include "View/IMessageSystem.h"
#include "Widgets/2D/List/ListWidget2D.h"

namespace hmibase {
namespace widget {
namespace trace {
class ListWidgetFinderCallback : public WidgetCheckCallback
{
   public:
      explicit ListWidgetFinderCallback(const Courier::UInt32& listId);
      virtual bool CheckWidget(Candera::Widget2D* widget);

      ListWidget2D* GetFlexListWidget2D()
      {
         return _flexListWidget2DPtr;
      }

   private:
      const Courier::UInt32 _listId;
      ListWidget2D* _flexListWidget2DPtr;

      // make it private so nobody can use it
      ListWidgetFinderCallback& operator=(const ListWidgetFinderCallback& rhs);
};


}	// namespace_trace
}


}	// namespace_hmibase

#endif // WIDGET_INSTANCE_FINDER_CALLBACK_HPP
