/* ***************************************************************************************
* FILE:          IndexedWidgetFinderCallback.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IndexedWidgetFinderCallback.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef INDEXED_WIDGET2D_FINDER_CALLBACK_H_
#define INDEXED_WIDGET2D_FINDER_CALLBACK_H_

#include "BaseContract/generated/BaseMsgs.h"
#include "Widgets/2D/Button/ButtonWidget2D.h"
#include "Widgets/2D/Text/TextWidget2D.h"

#include "CanderaWidget/Widget2D/Widget2D.h"

#include "hmi_trace_if.h"

namespace hmibase {
namespace widget {
namespace trace {

template <class T>
class IndexedWidgetFinderCallback : public WidgetCheckCallback
{
   public:
      explicit IndexedWidgetFinderCallback(const Courier::UInt32& buttonWidgetNum) :
         _widgetNum(buttonWidgetNum)
         , _widgetNumCounter(0)
         , _widget2DPtr(0)
      {
      }

      virtual bool CheckWidget(Candera::Widget2D* widgetPtr)
      {
         bool msgConsumed = false;

         if (widgetPtr != NULL)
         {
            T* tWidgetPtr = dynamic_cast <T*>(widgetPtr);
            if (tWidgetPtr != 0)
            {
               Candera::Node2D* nodePtr = tWidgetPtr->GetNode();
               if (nodePtr != 0)
               {
                  if (nodePtr->IsEffectiveRenderingEnabled())
                  {
                     if (_widgetNumCounter == _widgetNum)
                     {
                        HMIBASE_TRACE_VARG_CLS(ETG_LEVEL_FATAL, TR_CLASS_HMI_FW, "WidgetName = %.100s of the type = %.100s is found at given index", tWidgetPtr->GetLegacyName(), tWidgetPtr->GetTypeName());
                        _widget2DPtr = tWidgetPtr;
                        msgConsumed = true;
                     }
                     else
                     {
                        _widgetNumCounter++;
                     }
                  }
               }
            }
         }
         return msgConsumed;
      }

      T* GetWidgetPtr()
      {
         return _widget2DPtr;
      }

   private:
      const Courier::UInt32 _widgetNum;
      Courier::UInt32 _widgetNumCounter;
      T* _widget2DPtr;

      // make it private so nobody can use it
      IndexedWidgetFinderCallback& operator=(const IndexedWidgetFinderCallback& rhs);
};


}	// namespace_trace
}


}	// namespace_hmibase

#endif // __IndexedWidgetFinderCallback_H_
