/* ***************************************************************************************
* FILE:          CourierMsgTracing.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CourierMsgTracing is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/generated/WidgetsGenericMessages.h"
#include "Widgets/2D/List/Data/ListDataProvider.h"
#include "Widgets/2D/DropDownList/generated/DropDownListMessages.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> ::FeatStd::UInt32 StringBufferAppender< ListDataItem >::Append(::FeatStd::StringBuffer& stringBuffer, ListDataItem const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::DataItem { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< ListDataProvider >::Append(::FeatStd::StringBuffer& stringBuffer, ListDataProvider const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::ListDataProvider { ");
   char buf[50];
   SNPRINTF(buf, sizeof(buf), "listId=%u", object.listId());
   tcharCount += stringBuffer.Append(buf);
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< ListDataProviderUpdater >::Append(::FeatStd::StringBuffer& stringBuffer, ListDataProviderUpdater const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::ListDataProviderUpdater { ");
   char buf[50];
   SNPRINTF(buf, sizeof(buf), "listId=%u", object.listId());
   tcharCount += stringBuffer.Append(buf);
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< char* >::Append(::FeatStd::StringBuffer& stringBuffer, char* const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::char* { ");
   tcharCount += stringBuffer.AppendObject(const_cast<const char*>(object));
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< Candera::DropdownChangeType >::Append(::FeatStd::StringBuffer& stringBuffer, Candera::DropdownChangeType const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::Candera::DropdownChangeType { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


//////////////////////////


template<> ::FeatStd::UInt32 StringBufferAppender< std::string >::Append(::FeatStd::StringBuffer& stringBuffer, std::string const& object)
{
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::std::string { ");
   tcharCount += stringBuffer.Append(object.c_str());
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 StringBufferAppender< WidgetCheckCallback* >::Append(::FeatStd::StringBuffer& stringBuffer, WidgetCheckCallback* const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::WidgetCheckCallback* { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


}
#endif
