/* ***************************************************************************************
* FILE:          WidgetSet3DStandard.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WidgetSet3DStandard is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
//lint -emacro({665}, _CdaStaticAggregation)
//lint -emacro({446}, _CdaStaticAggregation)
#include "widget2D_std_if.h"
#include "Widgets/WidgetSetCore.h"

#include "Widgets/2Dext/HandWritingRecognition/LineListWidget3D.h"
#include "Widgets/3D/Animation/AnimationWidget3D.h"
#include "Widgets/3D/Blur/BlurWidget3D.h"
#include "Widgets/3D/DirectTexture/DirectTextureProvider3D.h"
#include "Widgets/3D/DirectTexture/DirectTextureConsumer3D.h"
#include "Widgets/3D/MultiSliderHelper/MultiSliderHelperWidget3D.h"
#include "Widgets/3D/TextureImage/TextureImageWidget3D.h"
#include "Widgets/3D/Button/SimpleButtonWidget3D.h"

CdaWidgetSetPartDefinitionBegin(WidgetSet3DStandard)
CdaDescription("HMI-Base Widget Set Standard for 3D")
CdaVersion(HMI_BASE_WIDGET_VERION)
CdaWidgets()
CdaWidget(AnimationWidget3D)
CdaWidget(LineListWidget3D)
CdaWidget(hmibase::widget::blur::BlurWidget3D)
CdaWidget(DirectTextureProvider3D)
CdaWidget(DirectTextureConsumer3D)
CdaWidget(MultiSliderHelperWidget3D)
CdaWidget(TextureImageWidget3D)
CdaWidget(SimpleButtonWidget3D)
CdaWidgetsEnd()
CdaWidgetSetPartDefinitionEnd(WidgetSet3DStandard)

WidgetSetAutoRegisterSelf(WidgetSet3DStandard)

#ifdef xxx
volatile class AutoRegister_WidgetSets2
{
   public:
      AutoRegister_WidgetSets2()
      {
         Init();
      }
      __declspec(dllexport) void Init()
      {
         RegisterWidgetSet(GetWidgetSet_WidgetSet3DStandard());
      }
};


static AutoRegister_WidgetSets2 dummyRegWidgetSets2;

static int keep_this /*__attribute__((used))*/ = 2;

void hallo()
{
   keep_this = 3;
}


#pragma comment(linker, "/include:?keep_this@")
#pragma comment(linker, "/include:?hallo@")
#pragma comment(linker, "/include:hallo")

#endif
