/* ***************************************************************************************
* FILE:          DirectTextureConsumer3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DirectTextureConsumer3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(DirectTextureConsumer3D_H)
#define DirectTextureConsumer3D_H

#include <Candera/Environment.h>
#include "Widgets/3D/BaseWidget3D.h"
#include <CanderaPlatform/Device/Common/Base/DirectTextureImage.h>
//#include <CanderaPlatform/Device/Common/OpenGLES20/GlTraceMapper.h>

namespace hmibase {
namespace gadget {
namespace videobuffer {
class VideoBufferType;
} // namespace
} // namespace
} // namespace

class DirectTextureConsumer3D : public BaseWidget3D
{
   public:

      DirectTextureConsumer3D();
      virtual ~DirectTextureConsumer3D();

      CGI_WIDGET_RTTI_DECLARATION(DirectTextureConsumer3D, BaseWidget3D);

      virtual void Init(Candera::AssetProvider* assetProvider);
      virtual void Update();

      void SetCamera(Candera::Node* camera)
      {
         m_camera = camera;
      }
      Candera::Node* GetCamera() const
      {
         return m_camera;
      }

      void SetDRMId(unsigned int id);

      CdaWidgetDef(DirectTextureConsumer3D, BaseWidget3D)
      CdaDescription("Direct Texture Consumer")
      CdaReadableName("DirectTextureConsumer3D")
      CdaCategory("Examples")

      CdaProperties()

      CdaProperty(Camera, Candera::Node*, GetCamera, SetCamera)
      CdaDescription("Camera used for intersection test.")
      CdaPropertyEnd()

      CdaPropertiesEnd()

      CdaWidgetDefEnd()

   private:
      Candera::MemoryManagement::SharedPointer<Candera::DirectTextureImage> m_directTextureImage;
      Candera::MemoryManagement::SharedPointer<Candera::Texture> m_texture;
      bool m_invalidated;
      Candera::Node* m_camera;
      hmibase::gadget::videobuffer::VideoBufferType* m_drmBuffer;
      unsigned int m_drmId;
      /**
       *  unload and upload the fbo.
       */
      bool Upload();
};


#endif // DirectTextureConsumer3D_H
