/* ***************************************************************************************
* FILE:          BlurViewScene3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BlurViewScene3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef BlurWidgetSpace_BlurViewScene3D_h__
#define BlurWidgetSpace_BlurViewScene3D_h__

#include "Widgets/utils/Blur/BlurTypes.h"

#ifdef COURIER_ENHANCED_ENABLED
#include <View/CGI/CgiExtensions/ViewScene3D.h>

namespace hmibase {
namespace widget {
namespace blur {

class BlurWidget3D;

class BlurViewScene3D : public hmibase::view::ViewScene3D
{
      typedef hmibase::view::ViewScene3D Base;
      typedef std::vector<BlurWidget3D*> BlurWidgetVector;
   public:
      BlurViewScene3D(bool managed = false);
      virtual ~BlurViewScene3D();

      virtual void Finalize();

      virtual bool IsUseDirtyAreaEnabled();

      virtual bool IsBlurEnabled();

      // Reimplementations of base class functions
      virtual bool DistributeMessage(const Courier::Message& msg);
      virtual void Update(Courier::RenderHint* renderHint);
      virtual void Invalidate(Courier::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea);
      virtual void Invalidate(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::Camera* camera, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::Camera* camera, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());
      virtual void Invalidate(Candera::RenderTarget* renderTarget, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

      void AddBlurWidget(BlurWidget3D* blurWidget);
      void RemoveBlurWidget(BlurWidget3D* blurWidget);

   private:
      BlurWidgetVector m_blurWidgets;
      FeatStd::Int m_maximalBlurRadius;

      void RetrieveMaximalBlurRadius();

      void DeleteWidgetRenderJobs(Candera::Camera* camera, BlurWidget3D* widget, Courier::Renderer* renderer);
      void DeleteBlurRenderJobs(BlurWidget3D* widget, Courier::Renderer* renderer);

      void InvalidateWidget(Candera::Camera* camera, BlurWidget3D* widget, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, Courier::Renderer* renderer);
      void InvalidateCamera(Candera::Camera* camera, Candera::UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, Courier::Renderer* renderer);
};


}   /* hmibase */
}   /* widget */
}   /* blur */

#endif  // BlurViewScene3D_h__
#endif
