/* ***************************************************************************************
* FILE:          AnimationWidget3D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationWidget3D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(AnimationWidget3D_h)
#define AnimationWidget3D_h

#include <Widgets/3D/Animation/generated/AnimationWidget3DBase.h>
#include <Candera/EngineBase/Animation/AnimationKeyframeSequence.h>
#include <Candera/EngineBase/Animation/EaseInterpolationStrategy.h>

class AnimationWidget3D : public AnimationWidget3DBase
{
   public:
      // Constructor and Destructor
      AnimationWidget3D();
      virtual ~AnimationWidget3D();

      // RTTI
      CGI_WIDGET_RTTI_DECLARATION(AnimationWidget3D, AnimationWidget3DBase);

      // Overwritten from base class
      virtual void Init(Candera::AssetProvider* assetFactory);
      virtual void Update();

      // Property Setter/Getter

   protected:
      // Overwritten from base class
      virtual void OnChanged(::FeatStd::UInt32 propertyId);

   private:
      // Checker function if target value is already reached
      bool IsTargetReached();

      Candera::Vector4 m_animationValue;     // current animation value
      Candera::UInt32 m_startTime;           // start time of animation
      Candera::UInt32 m_lastTime;            // memory for last entry time in Update function
      FeatStd::Int32 m_currentAnimationTime; // current time of animation

      // members to create a key frame based animation
      Candera::Animation::EaseInterpolationStrategy::SharedPointer m_interpolationStrategy;
      Candera::Animation::SequenceTimeType* m_sequence;
      Candera::Float* m_values;
      Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> m_kfs;

      CdaWidgetDef(AnimationWidget3D, AnimationWidget3DBase)
      CdaDescription("Provides support to create simple 3D animations")
      CdaCategory("Animation")
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif // AnimationWidget3D_h
