/* ***************************************************************************************
* FILE:          HandWritingCourierMsgTracing.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HandWritingCourierMsgTracing is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/generated/WidgetsGenericMessages.h"
#include "Widgets/2Dext/HandWritingRecognition/HWRBackendInterface.h"
#include "Widgets/2Dext/HandWritingRecognition/generated/HandWriting_Util_Widget2D_Base.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)

namespace FeatStd {
template<> ::FeatStd::UInt32 FeatStd::StringBufferAppender<HWRBackendInterface>::Append(FeatStd::StringBuffer& stringBuffer, HWRBackendInterface const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::HWRBackendInterface { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


template<> ::FeatStd::UInt32 FeatStd::StringBufferAppender<Candera::ACCESS_MODE>::Append(FeatStd::StringBuffer& stringBuffer, Candera::ACCESS_MODE const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::Candera::ACCESS_MODE { ");
   tcharCount += stringBuffer.Append("todo");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}


}
#endif
