/* ***************************************************************************************
* FILE:          HandWritingWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HWRBackendInterface.h part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015 Robert Bosch Car Multimedia GmbH
*
*  This software is part of the Bosch Widget Library and property of Robert Bosch GmbH.
*  Unauthorized duplication and disclosure to third parties is prohibited.
*  All rights reserved.
*************************************************************************************** */

#if !defined(HWR_BACKEND_INTERFACE_H)
#define HWR_BACKEND_INTERFACE_H
#include <string>
#include <vector>

class HWRBackendInterface
{
   private:
      static const FeatStd::Int8 VECTRO_SIZE;
      std::vector<std::string> _strArray;
      FEATSTD_SHARED_POINTER_DECLARATION();
   public:
      HWRBackendInterface();
      ~HWRBackendInterface();

      /**
      * Store the predicted word found by HandWriting library in a vetor.
      * @param[in] strtoStore Predicted Word found to be stored
      * @return void
      */
      void setString(::std::string strtoStore);

      /**
      * Used to retrieve the predicted word at a specific position in an array of predicted words

      * @param[in] index Predicted Word's Index
      * @return Returns predicted word if indix is valid else an empty string
      */
      ::std::string getString(FeatStd::UInt8 predictedWordAtIndex);

      /**
      * Gives number of the predicted words
      * @return Returns number of predicted words
      */
      FeatStd::UInt32 numberOfPredictedWords() const;
      static FeatStd::MemoryManagement::SharedPointer<HWRBackendInterface> pCreate();
};


/**Important for the creation of shared pointer otherwise there must be compilation error & it easy hard to find out */

namespace Candera {
namespace MetaInfo {
template<> struct DataType< Candera::MemoryManagement::SharedPointer<HWRBackendInterface> >
{
#if defined(CANDERA_META_DESCRIPTION)
   static const Char* GetEditor()
   {
      return "HWR Widget back end interface";
   }
#endif
   static bool ConvertToString(const Candera::MemoryManagement::SharedPointer<HWRBackendInterface>& /*pHWRBackendInterface*/, Candera::Char* buf, Candera::UInt /*bufLen*/)
   {
      *buf = 0;
      return true;
   }
   static bool ConvertFromString(Candera::MemoryManagement::SharedPointer<HWRBackendInterface>& /*pHWRBackendInterface*/, const Candera::Char* /*buf*/)
   {
      return true;
   }
};


}
}


#endif
