/* ***************************************************************************************
* FILE:          Touchable2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Touchable2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(Touchable2D_H)
#define Touchable2D_H

#include <Courier/Visualization/IViewHandler.h>
#include <View/CGI/Widget/WidgetGestureConfig.h>
#include <Widgets/2D/Touchable2DBase.h>
#include <Widgets/2D/Focus/Focusable2D.h>

namespace hmibase {
namespace widget {
namespace flags {
enum Enum_Touchable2D
{
   DisabledTouching = _LastValue_BaseWidget2D,

   //last value
   _LastValue_Touchable2D
};


}
}


}

class Touchable2D : public Touchable2DBase, public Focusable2DBase
{
   public:
      Touchable2D();
      virtual ~Touchable2D();

      //required for FlexList cloning, we are not extending ControlTemplateCloneableWidget yet, just to have the base properties cloned
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      virtual bool OnMessage(const Courier::Message& msg) override;
      virtual void Update() override;

      virtual void OnParentViewLoad(bool load) override;
      virtual void OnParentViewActivate(bool activate) override;

      virtual bool IsTouchable() const override
      {
         return GetTouchable();
      }

      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point);
      virtual bool OnTouchGeneric(const Candera::CanderaObject&, const Candera::Vector2&, FeatStd::Float dist = 0.0F) override;

      // widget can be touched also when it is disabled
      DefWidgetFlag(DisabledTouching, 0)

      bool IsInsideBoundingRect(const Courier::TouchInfo& msg);

      //Returns the priority of handling touch messages for this widget (0 is less prior than 1). The TouchSession has to use this priority as an additional sorting criteria.
      virtual TouchPriorityType GetEffectiveTouchPriority() const override;

      virtual hmibase::input::gesture::GestureListener::Gestures GetGestureList() const override;

      virtual GesturePriorizationParameter getGesturePriorizationParameter() const override;

      CGI_WIDGET_RTTI_DECLARATION(Touchable2D, Touchable2DBase);

      /////////////////////////////////////////////////////////////////////////
      // Widget definition
      CdaWidget2DDef(Touchable2D, Touchable2DBase)
      CdaProperties()

      CdaProperty_AppearanceId()
      CdaProperty_ControllerId()
      CdaProperty_UserData()

      CdaBindableProperty(DisabledTouching, bool, IsDisabledTouching, SetDisabledTouching)
      CdaDescription("Widget can be touched also when it is disabled.")
      CdaVisibilityTest(composerPropVisibleDisabledTouching)
      CdaBindablePropertyEnd()

      CdaProperty_Focusable()
      CdaProperty_FocusParentNode()
      CdaProperty_FocusControllerSet()
      CdaProperty_FocusOrder()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
      /////////////////////////////////////////////////////////////////////////

      // returns the gesture configuration set for this widget instance using the property GestureConfigId or the default configuration returned by getDefaultGestureConfig
      virtual WidgetGestureConfig getGestureConfig() const;
      // returns the default gesture configuration. Each widget type can have its own configuration.
      virtual WidgetGestureConfig getDefaultGestureConfig() const;

      virtual bool processGestureEvent(const hmibase::input::gesture::GestureEvent& gestureData) override;
      virtual hmibase::input::gesture::GUI_Rect getReceiverAbsoluteRect() override;
      virtual Candera::Rectangle GetWorldTouchableRectangle() const override;

      virtual void RegisterToFocusManagerImpl(Focus::FManager& focusManager, Focus::FSession& session, Focus::FWidgetConfig& handle)
      {
         DefaultRegisterToFocusManagerImpl(*this, focusManager, session, handle);
      }

   protected:
      virtual bool composerPropVisibleDisabledTouching() const
      {
         return false;
      }

      Courier::TouchInfo getCurrentSessionTouchInfo() const;
      Courier::TouchInfo getCurrentSessionStartTouchInfo() const;
      virtual bool OnTouchMessage(const Courier::TouchMsg& msg);

      virtual bool OnTapGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnPinchGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnRotateGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnRawTouchGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      void postTouchUpdMessage(hmibase::widget::enTouchState::Enum state);

   private:
      hmibase::input::TouchSession* _touchSession;
};


namespace hmibase {
namespace widget {
typedef Touchable2D TouchableWidget2D;
}


}

#endif    // Touchable2D_H
