/* ***************************************************************************************
* FILE:          ToggleWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ToggleWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ToggleWidget2D_H)
#define ToggleWidget2D_H

#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/Toggle/generated/ToggleWidget2DBase.h"

class ToggleWidget2D : public ToggleWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ToggleWidget2D, ToggleWidget2DBase);

      ToggleWidget2D();
      virtual ~ToggleWidget2D();

#ifdef VARIANT_S_FTR_ENABLE_DEPRECATED_TOGGLE_ENABLE
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void Update();

      void SetUseDeprecatedEnabled(bool use);
      bool GetUseDeprecatedEnabled() const
      {
         return _useDeprecatedEnabled;
      }

      void SetDeprecatedEnabled(bool enabled);
      bool GetDeprecatedEnabled() const
      {
         return _deprecatedEnabled;
      }

      virtual bool composerPropVisibleFilter_Enabled() const override
      {
         return false;
      }

      CdaWidget2DDef(ToggleWidget2D, ToggleWidget2DBase)
      CdaProperties() //Start of properties

      CdaProperty(UseDeprecatedEnabled, bool, GetUseDeprecatedEnabled, SetUseDeprecatedEnabled)
      CdaDescription("Enables the usage of the deprecated property Enabled. The default value of this property is true for legacy reasons (notice that also default VisibleEnabled is true for the same reasons).\n It is recommended to set this property to false and to control the node visibility by using the Visible property which is available in all widgets.")
      CdaPropertyEnd()

      CdaBindableProperty(Enabled, bool, GetDeprecatedEnabled, SetDeprecatedEnabled)
      CdaDescription("DEPRECATED. Configures the node property EnableRendering which is used to determine if the node is rendered or not. A node is effectively rendered if it and all its ancestors have rendering enabled.\n The same node property is configured also by the widget property Visible which is available in all widgets.\n Please notice that if the same property of a node is set from multiple sources then the result is unpredictable.")
      CdaVisibilityTest(GetUseDeprecatedEnabled)
      CdaBindablePropertyEnd()

      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

   protected:
      virtual void OnChanged(Courier::UInt32 /*propertyId*/);

      virtual void OnNodeChanged();

   private:
      bool _invalid;
      bool _useDeprecatedEnabled;
      bool _deprecatedEnabled;
#else

      CdaWidget2DDef(ToggleWidget2D, ToggleWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()

#endif
};


#endif
