/* ***************************************************************************************
* FILE:          ToggleWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ToggleWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "Widgets/2D/ControlTemplate/ControlTemplateBinding.h"

#include "lint_deactivation.h"
#include "ToggleWidget2D.h"


CGI_WIDGET_RTTI_DEFINITION(ToggleWidget2D);


ToggleWidget2D::ToggleWidget2D()
#ifdef VARIANT_S_FTR_ENABLE_DEPRECATED_TOGGLE_ENABLE
   : _invalid(true), _useDeprecatedEnabled(true/*for legacy reasons*/), _deprecatedEnabled(false/*for legacy reasons*/)
#endif
{
}


ToggleWidget2D::~ToggleWidget2D()
{
}


#ifdef VARIANT_S_FTR_ENABLE_DEPRECATED_TOGGLE_ENABLE

bool ToggleWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const ToggleWidget2D* original = CLONEABLE_WIDGET_CAST<const ToggleWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetUseDeprecatedEnabled(original->GetUseDeprecatedEnabled());

      if (ControlTemplateBinding::IsSelectedBindable(*this))
      {
         Candera::Int32 value = ControlTemplateBinding::GetSelectedValue(*this);
         SetDeprecatedEnabled(0 != value);
      }
      else
      {
         SetDeprecatedEnabled(original->GetDeprecatedEnabled());
      }

      cloned = true;
   }
   return cloned;
}


void ToggleWidget2D::Update()
{
   if (_invalid && (0 != GetNode()) && GetUseDeprecatedEnabled())
   {
      GetNode()->SetRenderingEnabled(GetDeprecatedEnabled());
      Invalidate();
      _invalid = false;
   }
}


void ToggleWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);

   //with recent changes in the base widget, changing of the Visible property from the base widget will call OnChanged,
   //so if _invalid is set here then in the next Update call the DeprecatedEnabled flag value will override the node visibility which was just set based on the Visible flag
   //_invalid = true;
}


void ToggleWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}


void ToggleWidget2D::SetUseDeprecatedEnabled(bool use)
{
   _useDeprecatedEnabled = use;
}


void ToggleWidget2D::SetDeprecatedEnabled(bool enabled)
{
   _deprecatedEnabled = enabled;
   _invalid = true;

   if (GetUseDeprecatedEnabled())
   {
      triggerUpdate();
   }
}


#endif
