/* ***************************************************************************************
* FILE:          TimerWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TimerWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TimerWidget2D_H)
#define TimerWidget2D_H

#include "Widgets/2D/TimerWidget/generated/TimerWidget2DBase.h"

class TimerWidget2D : public TimerWidget2DBase
{
   public:
      TimerWidget2D();

      virtual ~TimerWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(TimerWidget2D, TimerWidget2DBase);

      //Overridden from Candera::Widget2D
      virtual void OnParentViewRenderingEnabled(bool bIsEnabled);
      virtual bool OnMessage(const Courier::Message& f_orfMsg);

      //End of Overridden from Candera::Widget2D

   protected:
      virtual void Update();
      virtual void OnChanged(::Candera::UInt32 propertyId);

   private:
      ::Util::Timer _timer;

      void handleStartStopTrigger(bool bStartTimer);
      void handlePauseTrigger(bool bPause);
      bool setupTimer();
      bool startTimer();

      CdaWidget2DDef(TimerWidget2D, TimerWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
