/* ***************************************************************************************
* FILE:          TextWaitAnimationWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextWaitAnimationWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TEXTWAITANIMATIONWIDGET2D_H)
#define TEXTWAITANIMATIONWIDGET2D_H

#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include "Widgets/2D/TextWaitAnimation/generated/TextWaitAnimationWidget2DBase.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class TextWaitAnimationWidget2D : public TextWaitAnimationWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      TextWaitAnimationWidget2D();
      virtual ~TextWaitAnimationWidget2D();
      CGI_WIDGET_RTTI_DECLARATION(TextWaitAnimationWidget2D, TextWaitAnimationWidget2DBase);
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);
      void OnParentViewActivate(bool enable);

      void InitWidget();
      virtual void Update();
      Candera::Int16 calculateTextWidth(Candera::String string);
      void calAnimationPosition();
      Candera::ArrayProperty<FeatStd::Float> calKeyFrames(Candera::Vector2 textNodeEndPos, Candera::Int32 textLength, Candera::Int32 singleCharWidth);

   public:
      CdaWidget2DDef(TextWaitAnimationWidget2D, TextWaitAnimationWidget2DBase)
      CdaDescription("TextWaitAnimationWidget2D is used set the mask node position to play the animation using animation widget, TextWaitAnimationWidget2D and animation widget are associated to the mask node. It uses the text widget which should be associated with GlBitmapBrushMaskBlend.")
      CdaReadableName("TextWaitAnimationWidget2D")
      CdaCategory("Text")
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      Candera::String _text;
};


#endif
