/* ***************************************************************************************
* FILE:          TextExtensionWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextExtensionWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(TextExtensionWidget2D_H)
#define TextExtensionWidget2D_H

#include "Widgets/2D/BaseWidget2D.h"
#include "Widgets/2D/TextExtension/generated/TextExtensionWidget2DBase.h"
#include "Widgets/2D/Text/TextWidget2D.h"
#include "Candera/System/GlobalizationBase/Culture.h"

class TextExtensionWidget2D : public TextExtensionWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      TextExtensionWidget2D();
      virtual ~TextExtensionWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(TextExtensionWidget2D, TextExtensionWidget2DBase);
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual void InitWidget();
      virtual void Update();
      virtual bool OnMessage(const Message& msg);
      virtual void OnChanged(::FeatStd::UInt32 propertyId);
      virtual void OnNodeChanged();
      virtual void OnParentViewRenderingEnabled(bool viewLoaded);
      virtual void CultureChanged();

   public:
      CdaWidget2DDef(TextExtensionWidget2D, TextExtensionWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      void SetDirty()
      {
         _dirty = true;
      }

      void ResetDirty()
      {
         _dirty = false;
      }

      bool IsDirty() const
      {
         return _dirty;
      }

      void TimerStart();
      void TimerStop(bool deleteInstance = false);
      bool FindAncestorWidget();
      std::string FormatTextWithArgs();

      virtual bool ComposerPropFilterTimer() const;
      virtual bool ComposerPropFilterArgs() const;

   private:
      Candera::Globalization::Culture* _ptrCurrentCulture;
      TextWidget2D* _textWidget;
      unsigned _switchSelectedText;
      bool _dirty;
      int _ancestorSearchDone;
      ::Util::Timer* _timer;
      std::string _effText;
};


#endif
