/* ***************************************************************************************
* FILE:          TextColorWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextColorWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef TextColorWidget2D_H_
#define TextColorWidget2D_H_

#include "Widgets/2D/TextColor/generated/TextColorWidget2DBase.h"
#include "Widgets/2D/Text/TextWidget2D.h"

class TextColorWidget2D : public TextColorWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:

      CGI_WIDGET_RTTI_DECLARATION(TextWidgetWithColor, TextColorWidget2DBase);
      TextColorWidget2D(void);
      virtual ~TextColorWidget2D(void);

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   private:
      virtual void Update();
      virtual void OnNodeChanged();

      void UpdateTextWidget();
      const Candera::Color& GetTextStateColor() const;

      TextWidget2D* _textWidget;

      CdaWidget2DDef(TextColorWidget2D, TextColorWidget2DBase)
      CdaProperties()

      CdaBindableProperty(Active, bool, IsActive, SetActive)
      CdaDescription("Indicates that the text is active.")
      CdaCategory("Color")
      CdaBindablePropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
