/* ***************************************************************************************
* FILE:          TextColorWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextColorWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/TextColor/TextColorWidget2D.h"
#include "Widgets/2D/WidgetFinder2D.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateBinding.h"


CGI_WIDGET_RTTI_DEFINITION(TextColorWidget2D);


TextColorWidget2D::TextColorWidget2D(void): Base(),
   _textWidget(NULL)
{
}


TextColorWidget2D::~TextColorWidget2D(void)
{
   _textWidget = NULL;
}


void TextColorWidget2D::OnNodeChanged()
{
   Base::OnNodeChanged();
   _textWidget = NULL;
}


void TextColorWidget2D::UpdateTextWidget()
{
   if ((_textWidget == NULL) && (GetNode() != NULL))
   {
      _textWidget = WidgetFinder::FindAncestorWidget<TextWidget2D>(this);
   }
}


const Candera::Color& TextColorWidget2D::GetTextStateColor() const
{
   //disabled has the highest priority
   //check both the text widget and this widget
   if (((_textWidget != NULL) && (!_textWidget->IsEnabled())) || (!IsEnabled()))
   {
      return GetDisabledTextColor();
   }

   if (IsActive())
   {
      return GetActiveTextColor();
   }

   return GetNormalTextColor();
}


void TextColorWidget2D::Update()
{
   Base::Update();

   UpdateTextWidget();

   if (_textWidget != NULL)
   {
      const Candera::Color& color = GetTextStateColor();
      if (_textWidget->GetTextColor() != color)
      {
         _textWidget->SetTextColor(color);
         _textWidget->Invalidate();
      }
   }
}


bool TextColorWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const TextColorWidget2D* original = CLONEABLE_WIDGET_CAST<const TextColorWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNormalTextColor(original->GetNormalTextColor());
      SetDisabledTextColor(original->GetDisabledTextColor());
      SetActiveTextColor(original->GetActiveTextColor());

      if (ControlTemplateBinding::IsSelectedBindable(*this))
      {
         Candera::Int32 value = ControlTemplateBinding::GetSelectedValue(*this);
         SetActive(0 != value);
      }
      else
      {
         SetActive(original->IsActive());
      }

      cloned = true;
   }
   return cloned;
}
