/* ***************************************************************************************
* FILE:          TextStyleConfiguratorImpl.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TextStyleConfiguratorImpl is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "TextStyleConfiguratorImpl.h"


#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_TEXT
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TextStyleConfiguratorImpl.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace text {

bool TextStyleConfiguratorImpl::s_isAssetReadDone = false;
TextStyleConfigurator& TextStyleConfigurator::getInstance()
{
   return TextStyleConfiguratorImpl::getInstance();
}


TextStyleConfiguratorImpl& TextStyleConfiguratorImpl::getInstance()
{
   static TextStyleConfiguratorImpl s_obj;
   return s_obj;
}


TextStyleConfiguratorImpl::TextStyleConfiguratorImpl()
{
}


TextStyleConfiguratorImpl::~TextStyleConfiguratorImpl()
{
}


bool TextStyleConfiguratorImpl::registerStyle(StyleId styleId, StyleName styleName)
{
   return (m_styleEntries.insert(std::pair<StyleName, StyleId>(styleName, styleId))).second;
}


bool TextStyleConfiguratorImpl::unregisterStyle(StyleId /*styleId*/, StyleName styleName)
{
   return m_styleEntries.erase(styleName);
}


bool TextStyleConfiguratorImpl::registerExtensionStyle(StyleId styleId, TextStyleConfiguratorImpl::ExtensionType extensionType, StyleName styleName)
{
   switch (extensionType)
   {
      case Condensed:
         return (m_condensedStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      case Shrinked:
         return (m_shrinkedStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      case Bold:
         return (m_boldStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      case Italic:
         return (m_italicStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      case CondensedBold:
         return (m_consdensedBoldStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      case ShrinkedBold:
         return (m_shrinkedBoldStyleIds.insert(std::pair<StyleId, StyleName>(styleId, styleName))).second;
         break;
      default:
         break;
   }

   return false;
}


bool TextStyleConfiguratorImpl::unregisterExtensionStyle(StyleId styleId, TextStyleConfiguratorImpl::ExtensionType extensionType)
{
   size_t retValue = 0;
   switch (extensionType)
   {
      case Condensed:
         retValue = m_condensedStyleEntries.erase(styleId) || m_condensedStyleIds.erase(styleId);
         break;
      case Shrinked:
         retValue = m_shrinkedStyleEntries.erase(styleId) || m_shrinkedStyleIds.erase(styleId);
         break;
      case Bold:
         retValue = m_boldStyleEntries.erase(styleId) || m_boldStyleIds.erase(styleId);
         break;
      case Italic:
         retValue = m_italicStyleEntries.erase(styleId) || m_italicStyleIds.erase(styleId);
         break;
      case CondensedBold:
         retValue = m_condensedBoldStyleEntries.erase(styleId) || m_consdensedBoldStyleIds.erase(styleId);
         break;
      case ShrinkedBold:
         retValue = m_shrinkedBoldStyleEntries.erase(styleId) || m_shrinkedBoldStyleIds.erase(styleId);
         break;
      default:
         break;
   }
   return retValue ? true : false;
}


bool TextStyleConfiguratorImpl::readStylesFromAsset(Candera::AssetProvider* assetProvider)
{
   if (assetProvider != NULL)
   {
      Candera::DefaultAssetProvider* defaultAssetProvider = dynamic_cast<Candera::DefaultAssetProvider*>(assetProvider);
      if (defaultAssetProvider != NULL)
      {
         const Candera::AssetDescriptor& descriptor = defaultAssetProvider->GetAssetDescriptor();
         Candera::AssetDescriptor::AssetIdIterator it = descriptor.GetAssetIdIterator(Candera::TextStyleLib);
         while (it.IsValid())
         {
            if (false == defaultAssetProvider->GetTextStyleById(*it).PointsToNull())
            {
               m_assetStyleEnteries.insert(std::pair<StyleName, Style>(defaultAssetProvider->GetTextStyleById(*it).GetPointerToSharedInstance()->GetName(), defaultAssetProvider->GetTextStyleById(*it)));
            }
            ++it;
            s_isAssetReadDone = true;
         }
      }
   }
   //TODO : check if really required to return the status
   return s_isAssetReadDone;
}


bool TextStyleConfiguratorImpl::getExtensionStyleEntries(StyleId styleId, TextStyleConfiguratorImpl::ExtensionType extensionType, Style& style, Candera::AssetProvider* assetProvider)
{
   if (false == s_isAssetReadDone)
   {
      readStylesFromAsset(assetProvider);		//Initialize the map of text styles from asset
   }
   TextStyleConfiguratorImpl::ExtensionStyleEntries::iterator it;
   StyleIdEnteries::iterator itId ;
   AssetStyleEntries::iterator itAsset;
   switch (extensionType)
   {
      case Condensed:
      {
         it = m_condensedStyleEntries.find(styleId);

         if (it != m_condensedStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_condensedStyleIds.find(styleId);
            if (itId != m_condensedStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_condensedStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
      }
      break;
      case Shrinked:
      {
         it = m_shrinkedStyleEntries.find(styleId);
         if (it != m_shrinkedStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_shrinkedStyleIds.find(styleId);
            if (itId != m_shrinkedStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_shrinkedStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
      }
      break;
      case Bold:
      {
         it = m_boldStyleEntries.find(styleId);
         if (it != m_boldStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_boldStyleIds.find(styleId);
            if (itId != m_boldStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_boldStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
      }
      break;
      case Italic:
         it = m_italicStyleEntries.find(styleId);
         if (it != m_italicStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_italicStyleIds.find(styleId);
            if (itId != m_italicStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_italicStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
         break;
      case CondensedBold:
         it = m_condensedBoldStyleEntries.find(styleId);
         if (it != m_condensedBoldStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_consdensedBoldStyleIds.find(styleId);
            if (itId != m_consdensedBoldStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_condensedBoldStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
         break;
      case ShrinkedBold:
         it = m_shrinkedBoldStyleEntries.find(styleId);
         if (it != m_shrinkedBoldStyleEntries.end())
         {
            style = it->second;
            return true;
         }
         else
         {
            itId = m_shrinkedBoldStyleIds.find(styleId);
            if (itId != m_shrinkedBoldStyleIds.end())
            {
               StyleName styleName = itId->second;
               itAsset = m_assetStyleEnteries.find(styleName);
               if (itAsset != m_assetStyleEnteries.end())
               {
                  style = itAsset->second;
                  //This is to store the style for next time , if widget ask for this style id , it can directly have in StyleEntries
                  m_shrinkedBoldStyleEntries.insert(std::pair<StyleId, Style&>(styleId, itAsset->second));
                  return true;
               }
            }
         }
         break;
      default:
         return false;
   }
   return false;
}


FeatStd::Int16 TextStyleConfiguratorImpl::getTextStyleId(StyleName styleName)
{
   StyleEntries::iterator it = m_styleEntries.find(styleName);
   if (it != m_styleEntries.end())
   {
      return it->second;
   }
   return -1;
}


size_t TextStyleConfiguratorImpl::getStyleEntriesCount()
{
   return m_styleEntries.size();
}


size_t TextStyleConfiguratorImpl::getCondensedStyleEntriesCount()
{
   return m_condensedStyleEntries.size();
}


size_t TextStyleConfiguratorImpl::getShrinkedStyleEntriesCount()
{
   return m_shrinkedStyleEntries.size();
}


size_t TextStyleConfiguratorImpl::getAssetStyleEntriesCount()
{
   return m_assetStyleEnteries.size();
}


} // namespace
} // namespace
} // namespace
