/* ***************************************************************************************
* FILE:          SurfaceInputRegionWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceInputRegionWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(InputRegionWidget2D_H)
#define InputRegionWidget2D_H

#include <View/CGI/InputHandling/SurfaceInputRegionManager.h>
#include <Widgets/2D/SurfaceInputRegion/generated/SurfaceInputRegionWidget2DBase.h>
#include <Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h>


/*****************************************************************************/
class SurfaceInputRegionWidget2D : public SurfaceInputRegionWidget2DBase, public hmibase::input::SurfaceInputRegionWidgetConfig
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(SurfaceInputRegionWidget2D, SurfaceInputRegionWidget2DBase);

      SurfaceInputRegionWidget2D();

      virtual ~SurfaceInputRegionWidget2D();

      virtual void Update();

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      virtual hmibase::enSurfaceInputRegionOperation::Enum getInputRegionOperation() const;
      virtual Candera::Rectangle getInputRegionRectangle() const;

      virtual bool composerPropVisibleFilter_Enabled() const override
      {
         return true;
      }

      CdaWidget2DDef(SurfaceInputRegionWidget2D, SurfaceInputRegionWidget2DBase)
      CdaProperties() //Start of properties
      CdaPropertiesEnd() // End of properties
      CdaWidgetDefEnd()
};


#endif
