/* ***************************************************************************************
* FILE:          SurfaceInputRegionWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceInputRegionWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "lint_deactivation.h"
#include "SurfaceInputRegionWidget2D.h"
#include <View/CGI/InputHandling/SurfaceInputRegionManager.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_TOUCHABLE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/SurfaceInputRegionWidget2D.cpp.trc.h"
#endif

CGI_WIDGET_RTTI_DEFINITION(SurfaceInputRegionWidget2D);


/*****************************************************************************/
SurfaceInputRegionWidget2D::SurfaceInputRegionWidget2D()
{
}


/*****************************************************************************/
SurfaceInputRegionWidget2D::~SurfaceInputRegionWidget2D()
{
}


/*****************************************************************************/
bool SurfaceInputRegionWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const SurfaceInputRegionWidget2D* original = CLONEABLE_WIDGET_CAST<const SurfaceInputRegionWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetOperation(original->GetOperation());

      cloned = true;
   }
   return cloned;
}


/*****************************************************************************/
void SurfaceInputRegionWidget2D::Update()
{
   Base::Update();

   if (IsEnabled())
   {
      hmibase::input::SurfaceInputRegionManager::getInstance().addInputRegionWidget(this, this);
   }
}


/*****************************************************************************/
hmibase::enSurfaceInputRegionOperation::Enum SurfaceInputRegionWidget2D::getInputRegionOperation() const
{
   return GetOperation();
}


/*****************************************************************************/
Candera::Rectangle SurfaceInputRegionWidget2D::getInputRegionRectangle() const
{
   const Candera::Node2D* node = GetNode();
   if (node != NULL)
   {
      Candera::Rectangle rect;
      node->GetEffectiveBoundingRectangle(rect);
      rect.SetPosition(rect.GetPosition() + node->GetWorldPosition());
      return rect;
   }
   return Candera::Rectangle();
}
