/* ***************************************************************************************
 * FILE:          StepAnimationWidget2D.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  StepAnimationWidget2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#if !defined(StepAnimationWidget2D_h)
#define StepAnimationWidget2D_h

#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#include "Widgets/2D/StepAnimation/generated/StepAnimationWidget2DBase.h"

namespace hmibase {
namespace widget {
namespace util {
class SharedTimerManager;
}


}
}


// Provides support to animate properties with discrete values. This has the advantage that update is not performed continously resulting in reduced CPU usage.
// It is suited for wait animations, blink animations and other situations when animations have to run for a longer time.
// The widget uses a timer to trigger the updates and this timer can be shared between multiple instances so they all update in the same time.
class StepAnimationWidget2D : public StepAnimationWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      StepAnimationWidget2D();
      virtual ~StepAnimationWidget2D();

      typedef Candera::ArrayProperty<FeatStd::Float> KeyframeValuesType;

      CGI_WIDGET_RTTI_DECLARATION(StepAnimationWidget2D, StepAnimationWidget2DBase);

      /////////////////////////////////////////////////////////////////////////
      // overrides from Courier::FrameworkWidget
      virtual void OnParentViewRenderingEnabled(bool viewLoaded);

      // overrides from Candera::Widget
      virtual void OnChanged(FeatStd::UInt32 propertyId);
      virtual void OnNodeChanged();
      virtual bool OnMessage(const Courier::Message& msg);
      virtual void Update();

      // overrides from ControlTemplateCloneableWidget
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      const KeyframeValuesType& getKeyframeValues() const
      {
         return _keyframeValues;
      }
      void setKeyframeValues(const KeyframeValuesType& keyframeValues)
      {
         _keyframeValues = keyframeValues;
      }

      CdaWidget2DDef(StepAnimationWidget2D, StepAnimationWidget2DBase)
      CdaProperties()

      CdaFieldProperty(Values, KeyframeValuesType, _keyframeValues)
      CdaDescription("Stores the keyframe values. Depending on the type of the animated property the number of values for each keyframe is between 1 and 4. \n1 value is required for simple types (bool, int, float);  \n2 values are required for Vector2;  \n3 values are required for Vector3;  \n4 values are required for Color, Rectangle and Margin;")
      CdaPropertyEnd()

      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      // starts the animation by initializing the property setter and acquiring (and starting) the timer
      void startAnimation();

      // stops the animation by releasing the timer
      void stopAnimation(bool resetToEndKeyframe = false);

      // called when the timer expires to update the node or widget property value
      void animate();

      // verifies the specified index and updates the keyframe index
      void checkAndSetKeyframeIndex(size_t index);

      // creates the property setter which changes the node or widget property value
      void createPropertySetter();

      // the number of channels depends on the property to be animated:
      // - Alpha, Rotation and RenderingEnabled have 1 channel
      // - Position and Scale have 2 channels (x and y)
      // - the channel count for widget properties is specified as a config property because it is not possible (easy) to determine it
      size_t getEffectiveChannelCount() const;

      // calculates the number of keyframes based on keyframe values size and channel count
      size_t getEffectiveKeyframeCount() const;

      static hmibase::widget::util::SharedTimerManager& getSharedTimerManager();

      // node or properties were changed and animation must be (re)initialized
      bool _invalid;

      // timer was acquired and started
      bool _timerAcquired;

      // index of the shared timer instance
      FeatStd::Int32 _acquiredTimerSharedInstance;

      // property setter which changes the node or widget property value
      Candera::Animation::AnimationPropertySetter::SharedPointer _propertySetter;

      // values used for keyframes, the size of this array is KeyframeCount*ChannelCount
      KeyframeValuesType _keyframeValues;

      // current keyframe
      FeatStd::Int32 _keyframeIndex;
};


#endif // StepAnimationWidget2D_h
