/* ***************************************************************************************
* FILE:          SpellerWidget2D_View.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerWidget2D_View is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/BaseWidget2D.h"
#include "SpellerWidget2D_View.h"


/****************************************************************************
* Req ID      : NA
* Function    : SpellerWidget2D_View()
* Called by   : HMI Framework when SpellerWidget2D_View object is created
* Description : Constructor of class where initializations are done
* Parameters  : None
* Return      : None
* History     : 2013-07-17(kea2kor) Initial version
*               2013-07-30(kea2kor) Intermediate release
*****************************************************************************/
SpellerWidget2D_View::SpellerWidget2D_View()
{
   m_pWidget = NULL;
}


/****************************************************************************
* Req ID      : NA
* Function    : ~SpellerWidget2D_View()
* Called by   : HMI Framework when SpellerWidget2D_View object is deleted
* Description : Destructor of class where we reset necessary variables
*               while moving out of scope
* Parameters  : None
* Return      : None
* History     : 2013-07-17(kea2kor) Initial version
*               2013-07-30(kea2kor) Intermediate release
*****************************************************************************/
SpellerWidget2D_View::~SpellerWidget2D_View()
{
   m_pWidget = NULL;
}


/****************************************************************************
* Req ID      : NA
* Function    : vSetWidget()
* Called by   : Physical widget SpellerWidget2D(Model in MVC)constructor
* Description : Assigns the Main widget instance pointer to SpellerView class
* Parameters  : SpellerWidget2D*
* Return      : None
* History     : 2013-07-17(kea2kor) Initial version
*               2013-07-30(kea2kor) Intermediate release
*****************************************************************************/
void SpellerWidget2D_View::vSetWidget(SpellerWidget2D* pWidget)
{
   m_pWidget = pWidget;
}


/****************************************************************************
* Req ID      : NA
* Function    : Update
* Called by   : HMI Framework during every render cycle
* Description : Overloaded function which the widget can use to perform any
*               custom business logic on every render cycle
* Parameters  : None
* Return      : None
* History     : 2013-07-17(kea2kor) Initial version
*               2013-07-30(kea2kor) Intermediate release
****************************************************************************/
void SpellerWidget2D_View::Update()
{
   //any logic to be done on every render cycle
   //Should be carefully used as it can lead to performance bottlenecks
   //May be a flag should be used for the same
   //...
}
