/* ***************************************************************************************
* FILE:          SpellerWidget2D_Ctrl.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SpellerWidget2D_Ctrl is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HTC_SPELLERWIDGET_2D_CTRL_H
#define HTC_SPELLERWIDGET_2D_CTRL_H

//Header files
#include "Widgets/2D/Button/ButtonWidget2D.h"

class SpellerWidget2D;
class SpellerWidget2D_CtrlBase;

class SpellerWidget2D_Ctrl
{
   public:

      SpellerWidget2D_Ctrl();
      virtual ~SpellerWidget2D_Ctrl();

      //To set the pointer of Physical widget
      void vSetWidget(SpellerWidget2D* pWidget);

      /**
      * Over-ridden Framework functions
      */

      //Touch Intersection test Interface
      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point);
      //Message distribution Interface
      virtual bool OnMessage(const Message& msg);

      /**
      * User-defined public member functions
      */

      //Function to check if the pressed button has a sub-speller character
      bool bIsSubSpellerChar(Candera::UInt8 u8Index);
      //Function to toggle the enable property of all the Speller character buttons
      virtual void vToggleAllCharBtnEnableStatus(const bool bEnableStatus);
      virtual void vDisableAllCharBtnStatus(const bool bEnableStatus);

   protected:

   private:

      /**
      * User-defined private Member functions
      */

      //Functions for handling Button reaction messages
      bool bOnButtonMsg(const Courier::Message& msg);
      bool bHandleButtonMsg(const Courier::Message& msg, Candera::UInt8 u8Index);
      void vOnButtonPress(Candera::UInt8 u8Index);
      void vOnButtonRelease(Candera::UInt8 u8Index, const enReaction& reaction);
      void vOnButtonShortORLongPress(Candera::UInt8 u8Index, const enReaction& reaction);

      void vHandleFreeModeActions(Candera::UInt8 u8Index);
      void vHandleMatchModeActions(Candera::UInt8 u8Index);
      void vHandleModeIndependentActions(Candera::UInt8 u8Index);
      void vHandleDeleteLongPress(Candera::UInt8 u8Index);
      void vHandleZeroLongPress(Candera::UInt8 u8Index);
      void vPostPressedControlCharMsg(Candera::UInt8 u8Index);
      void onButtonRepeatPressSec(Candera::UInt8 u8Index);

#ifdef xxxhtcFocusHandlingxxx
      //Functions for Rotary user event
      bool bOnRotaryMsg(const Message& msg);
      void vOnRotaryTurnPosMsg();
      void vOnRotaryTurnNegMsg();

      //Functions for routing Ok/Enter user events
      bool bOnOKMsg(const Message& msg);

      //Functions for routing Joystick direction user events
      bool  bOnJoystickKBDMsg(const Message& msg);
#endif

      /**
      * private Member variables
      */

      SpellerWidget2D*            m_pWidget;                     //Stores the physical widget instance
      bool m_lockState;
};


#endif // HTC_SPELLERWIDGET_2D_CTRL_H
