/* ***************************************************************************************
* FILE:          SliderWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SliderWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef SLIDER_WIDGET2D_H
#define SLIDER_WIDGET2D_H

#include <View/CGI/Widget/WidgetController.h>
#include "Widgets/2D/Slider/generated/SliderWidget2DBase.h"
#include "Widgets/2D/Slider/generated/SliderWidget2DTypes.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"


class SliderWidget2D : public SliderWidget2DBase
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(SliderWidget2D, SliderWidget2DBase);

      SliderWidget2D();
      virtual ~SliderWidget2D();

      //required for FlexList cloning
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

      //Overridden methods
      virtual void InitWidget();
      virtual void CultureChanged();
      virtual void Update();

      virtual bool OnMessage(const Courier::Message& msg);
      virtual void OnLostFocus();
      virtual void OnFocus();
      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point);

      virtual WidgetGestureConfig getGestureConfig() const override;

   protected:
      virtual void OnChanged(::Candera::UInt32 propertyId);
      FeatStd::Float    _valueInteral;				//moved to protected to access it from angularslider
      bool              _updatePositionOnNextFrame; //moved to protected to access it from angularslider
      // Gesture interface
      virtual bool OnTapGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      void setCurrentValue(bool writeToDataModel);	//moved to protected to access it from angularslider
      void dirty();									//moved to protected to access it from angularslider
      bool checkValidStepsConfiguration();			//moved to protected to access it from angularslider

      bool bSendCurrentValChangedMsg();
   private:
      //  widget functionality
      FeatStd::Float    _scaleStart;        // in pixel
      FeatStd::Float    _scaleEnd;          // in pixel
      FeatStd::Float    _markerHalfSize;    // in pixel
      //bool              _updatePositionOnNextFrame;
      //FeatStd::Float    _valueInteral;
      bool              _bIsInTouchSession;
      bool              _bMarkerBitmapChanged;
      bool              _bIsSliderSelected;
      FeatStd::Float    _stepSizeInteral;  // we should not overwrite the StepSize property
      enum SliderMakerMode
      {
         MarkerNormal,
         MarkerPressed
      };
      SliderMakerMode   _markerMode;
      // member for changing the slider marker bitmap
      Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> _bitmapMarker;
      bool              _rightToLeft; // for Arabic slider
      SliderTouchState _sliderTouchState;
   private: // Scenecomposer property filter
      bool ComposerPropFilterNumOfSteps() const
      {
         return (GetUseNumofSteps() && ComposerPropFilterNotProgressbarMode());
      }
      bool ComposerPropFilterStepSize() const
      {
         return (!GetUseNumofSteps() && ComposerPropFilterNotProgressbarMode());
      }
      bool ComposerPropFilterNotProgressbarMode() const
      {
         return true;
      }
      bool ComposerPropFilterFillerNodeConnected() const
      {
         return (GetBitmapFillNode() != NULL);
      }

   private:
      inline FeatStd::Float getScaleWidth() const
      {
         return (_scaleEnd - _scaleStart);
      }
      // widget initialization
      //void setCurrentValue(bool writeToDataModel);
      void numOfStepsReceived();
      void alignFillNode();
      // visibility check
      bool checkSliderStepsMode() const;
      bool checkSliderSizeMode() const;
      // init the movable area of the slider marker
      virtual bool initializeEffectiveMovableArea();

      // handling user Touch
      virtual bool bOnTouchMessage(const Courier::Message& msg);
      // update the marker bitmap based on the marker state
      void updateMarkerBitmap();
      void setMarkerMode(SliderMakerMode mode);
      void setTouchStatus(const SliderTouchState state);
      // Start - Misc methods
      virtual void updatePosition();
      // bool checkValidStepsConfiguration();
      void calcMarkerValue();
      //void dirty();
      FeatStd::Float calculateValueOnGraphPosition(FeatStd::Float xPos, FeatStd::Float yPos) const;
      bool isInsideBoudingRectangle(FeatStd::Float xPos, FeatStd::Float yPos);
      FeatStd::Float nearestStepSizeValue(Candera::Float value) const;
      bool _isPartofList;
      CdaWidget2DDef(SliderWidget2D, SliderWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


/****************************************************************************/
class SliderController2DData : public hmibase::widget::WidgetControllerData
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetControllerData);

   public:
      CANDERA_RTTI_DECLARATION(SliderController2DData);
};


/****************************************************************************/
class SliderController2D : public hmibase::widget::WidgetController
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::WidgetController);

   public:
      CANDERA_RTTI_DECLARATION(SliderController2D);

      WIDGET_CONTROLLER_ON_GESTURE()
      virtual bool OnTapGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnDragGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnSwipeGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnPinchSpreadGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
      virtual bool OnRotateGesture(DelegateWidget&, const hmibase::input::gesture::GestureEvent&)
      {
         return false;
      }
};


/****************************************************************************/
class DefaultSliderController2DData : public SliderController2DData
{
      FEATSTD_TYPEDEF_BASE(SliderController2DData);

   public:
      CANDERA_RTTI_DECLARATION(DefaultSliderController2DData);
};


/****************************************************************************/
class DefaultSliderController2D : public SliderController2D
{
      FEATSTD_TYPEDEF_BASE(SliderController2D);

   public:
      CANDERA_RTTI_DECLARATION(DefaultSliderController2D);

      virtual hmibase::widget::WidgetControllerData* CreateData(DelegateWidget&) override
      {
         return CANDERA_NEW(DefaultSliderController2DData);
      }
};


#endif
