/* ***************************************************************************************
* FILE:          ListWidget2DSliderWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListWidget2DSliderWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "Widgets/2D/ControlTemplate/ControlTemplateBinding.h"
#include "Widgets/2D/Slider/generated/ListWidget2DSliderMessages.h"

#include "ListWidget2DSliderWidget2D.h"

using namespace FeatStd;

void ListWidget2DSliderWidget2D::OnChanged(::Candera::UInt32 propertyId)
{
   switch (propertyId)
   {
      case CurrentValuePropertyId:
      {
         if (0 != GetParentView())
         {
            FEATSTD_DEBUG_ASSERT(GetCurrentValue() >= 0.0);
            bool _status = bSendCurrentValChangedMsg();
            if (_status)
            {
               if (ControlTemplateBinding::IsSelectedBindable(*this))
               {
                  ControlTemplateBinding::SetSelectedValue(*this, Int32(GetCurrentValue()));
               }
            }
         }
         break;
      }
      default:
         break;
   }
   SliderWidget2D::OnChanged(propertyId);
}
