/* ***************************************************************************************
* FILE:          ScrollableTextWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScrollableTextWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(ScrollableTextWidget2D_h)
#define ScrollableTextWidget2D_h

#include "Widgets/2D/ScrollableText/generated/ScrollableTextWidget2DBase.h"
//#include "Widgets/2D/ScrollableText/Scrollable.h"
#include "Widgets/2D/Common/FlexScrollable.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"
#ifdef RICHTEXT_PERFORMANCE_CHECK
#include "hmibase/util/Ticker.h"
#endif
//Macro defined for swipe action
#define ListChangeSwipe 5

class ScrollableTextWidget2D : public ScrollableTextWidget2DBase, public FlexScrollable
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      // constructor/destructor
      ScrollableTextWidget2D();
      virtual ~ScrollableTextWidget2D();

      // overridden from WidgetBase
      virtual void InitWidget();
      virtual void Update();
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);
      // RTTI
      CGI_WIDGET_RTTI_DECLARATION(ScrollableTextWidget2D, ScrollableTextWidget2DBase);

      // overridden from Framework widget
      virtual bool OnMessage(const Courier::Message& msg);
      virtual bool OnTouch(const Candera::Camera2D& camera2D, const Candera::Vector2& point);
      Candera::ListScrollingOrientation _listscroll;

      /// Called when Localization/Culture has changed during runtime
      void OnCultureChangeIndMsg();

      // overridden from Scrollable
      virtual void RequestImmediatePositioning(bool active);
      virtual bool IsScrollBarVisible();
      virtual Candera::UInt32 GetPosition();
      virtual Candera::UInt32 GetFirstFullyVisiblePosition();
      virtual Candera::UInt32 GetVisibleSize();
      virtual Candera::UInt32 GetCompleteSize();
      virtual Candera::Widget2D* GetWidget();
      virtual Candera::UInt32 GetMaxPosition();
      virtual bool IsCircular();
      virtual WidgetGestureConfig getDefaultGestureConfig() const;
      virtual bool OnSwipeGesture(const hmibase::input::gesture::GestureEvent& gestureData);
      virtual bool OnDragGesture(const hmibase::input::gesture::GestureEvent& gestureData);

      // virtual void UpdatePositionOnSwiping(Candera::Float movingDistance){ FEATSTD_UNUSED(movingDistance); }
      //virtual void SetFocus(Candera::UInt32 positionX, Candera::UInt32 positionY) { FEATSTD_UNUSED2(positionX, positionY); }
      virtual const ::Candera::ListScrollingOrientation& GetScrollingOrientation() const
      {
         return _listscroll;
      }

      CdaWidget2DDef(ScrollableTextWidget2D, ScrollableTextWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      // overridden from ScrollableTextWidget2DBase
      virtual void OnChanged(Candera::UInt32 propertyId);

      // overridden from RichTextWidget
      virtual void vUpdateNode();
      void UpdateSwipe();

      virtual bool bIsReLayoutNeeded();
      virtual bool bIsReRenderNeeded();

      virtual void vLayoutRichText();
      virtual void vRenderRichText();

      void SetListener(FlexScrollableListener* listener); // overwritten FlexScrollable interface

   private:
      static const Candera::TChar c_Text_Command_Mark;
      static const Candera::TChar c_Text_Color_Mark;
      static const Candera::TChar c_Text_Tab_Mark;

      class TabStopTableListEvent
      {
         public:
            ScrollableTextWidget2D* m_pWidget;
            void OnTabStopTableListEvent(const Courier::ListEvent& listEvent);
      };
      friend class TabStopTableListEvent;

      TabStopTableListEvent m_oTabStopTableListEvent;

      class ColorTableListEvent
      {
         public:
            ScrollableTextWidget2D* m_pWidget;
            void OnColorTableListEvent(const Courier::ListEvent& listEvent);
      };
      friend class ColorTableListEvent;

      ColorTableListEvent m_oColorTableListEvent;

      RichText::RichTextChunk* oParseText(const FeatStd::String& oText);

      RichText::RichTextChunk* m_pParsedTextChunks;

      RichText::tTabStopList m_oTabStopCache;
      std::vector<Candera::Color> m_oColorCache;

      Candera::UInt32 m_u32ScrollPosition;

      bool m_bIsReparse;
#ifdef RICHTEXT_PERFORMANCE_CHECK
      hmibase::util::Ticker _tPerf;
#endif

      FeatStd::String oInputText;
      FeatStd::String oOrginalString;
      Candera::UInt32 _startIndex;
      Candera::UInt _layoutcount;
      Candera::UInt _noOfLayout;
      Candera::UInt32  _maxBlockCharCount;
      Candera::UInt32  _maxLineCharCount;
      //The variable used to render first layout content properly on page up operation
      Candera::UInt32 _firstPageRendrdCharcount;
      Candera::Float _virtualMaxScrollPosition;
      Candera::UInt32 _currentMaxIndex;
      Candera::Float _PreviousvirtualMaxScrollPosition;
      Candera::UInt32 _PreviousMaxIndex;
      Candera::UInt32 _contentSize;
      Candera::UInt16 _numOfLinesPerTextArea;
      Candera::Int16 _defaultFontLineHeight;
      Candera::Int16 _pageupCount;
      Candera::Int16 _lineupCount;
      Candera::UInt32 _lastdragMsgVal;
      bool _dragLastPage;
      FlexScrollableListener* _listener;
      bool _isLayoutNeeded;
      bool _scrollbarVisibility;
      bool IsChangedScrollPosition;
      // variable used to identify the event that changes the visible content in text area
      Candera::UInt16 u16ListChangeType;

      Candera::Int32 _numLinesToSwipe;
      void vCopyBlockOfText(Candera::UInt32 BlockCharCount);
      void vCopyBlockOfTextForPageUp(Candera::UInt32 BlockCharCount);
      void vCopyBlockOfTextforPageDown(Candera::UInt32 BlockCharCount);
      void vCopyBlockOfTextForLineUp();
      void vCopyBlockOfTextforLinedown(Candera::UInt32 BlockCharCount);
      bool isMaxBlockCharsCopied(Candera::UInt32 _sourcestartIndex);
      bool isProvidedBlockCharsCopied(Candera::UInt32 startIndex, Candera::UInt32 BlockCharCount);
      void vSendRichTextForLayouting(bool isPageDown = true);
      void vSetRenderOffsetValue(const ListChangeMsg* lMsg);
      void vGetStartIndxWithWordWrap(Candera::UInt32 _startIndex);
      void vApplyLayoutForRichText();
      //Added the function to reuse the logic defined to set renderoffset value for single layout approach.
      void vSetSingleLayoutRenderOffsetValue(ListChangeType enListChangeType, Candera::Int32 i32Value);

      // Changes done to improve the scrollbar movement with respect to complete text content.

      // Scrollbar callback notification
      void ScrollbarNotifyOnPositionReached();
      void ScrollbarNotifyOnContentChanged();

      // sends current and maximum scroll position update
      void vUpdateScrollPosition();
      void vPostUpdateMessage();
      void GetValidMaxBlockCharCount(Candera::UInt32 _sourceStartIndex, Candera::UInt32&   maxBlockCharCount);
      void GetValidStartIndex(Candera::UInt32& _sourceStartIndex);
      bool IsValidByte(Candera::UInt32 index);
};


#endif // ScrollableTextWidget2D_h
