/* ***************************************************************************************
* FILE:          ScrollBarButtonWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScrollBarButtonWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(FlexScrollBarButton2D_H)
#define FlexScrollBarButton2D_H

#include "Widgets/2D/ScrollBarButton/generated/ScrollBarButtonWidget2DBase.h"

class ScrollBarWidget2D;

class ScrollBarButtonWidget2D : public ScrollBarButtonWidget2DBase
{
   public:
      ScrollBarButtonWidget2D();
      virtual ~ScrollBarButtonWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ScrollBarButtonWidget2D, ScrollBarButtonWidget2DBase);

      virtual void Press();
      virtual void Release();

      CdaWidget2DDef(ScrollBarButtonWidget2D, ScrollBarButtonWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   private:
      void GenerateEvent();
      ScrollBarWidget2D* GetAssociatedScrollBar();
};


#endif
