/* ***************************************************************************************
* FILE:          ScrollBarButtonWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScrollBarButtonWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/2D/ScrollBar/ScrollBarWidget2D.h"
#include "Widgets/2D/ControlTemplate/ControlTemplate.h"
#include <Courier/Visualization/ViewScene.h>

#include "lint_deactivation.h"
#include "ScrollBarButtonWidget2D.h"

using namespace Candera;
using namespace Courier;

CGI_WIDGET_RTTI_DEFINITION(ScrollBarButtonWidget2D);

ScrollBarButtonWidget2D::ScrollBarButtonWidget2D()
{
}


ScrollBarButtonWidget2D::~ScrollBarButtonWidget2D()
{
}


void ScrollBarButtonWidget2D::Press()
{
   Base::Press();
   if (GetOnPress())
   {
      GenerateEvent();
   }
}


void ScrollBarButtonWidget2D::Release()
{
   Base::Release();
   if (!GetOnPress())
   {
      GenerateEvent();
   }
}


void ScrollBarButtonWidget2D::GenerateEvent()
{
   ScrollBarWidget2D* scrollBar(GetAssociatedScrollBar());
   if (0 != scrollBar)
   {
      scrollBar->RequestNewPosition(static_cast<ListChangeType>(GetChangeType()), GetAmount());
   }
}


ScrollBarWidget2D* ScrollBarButtonWidget2D::GetAssociatedScrollBar()
{
   Node2D* node(GetNode());
   ScrollBarWidget2D* scrollBar(0);

   ViewScene* viewScene = static_cast<ViewScene*>(GetParentView());
   if (0 != viewScene)
   {
      while ((0 != node) && (0 == scrollBar))
      {
         WidgetBaseEnumerator enumerator = ControlTemplate::EnumerateAssociatedWidgets(*viewScene, *node);
         while ((0 == scrollBar) && enumerator.MoveNext())
         {
            FEATSTD_LINT_NEXT_EXPRESSION(740, "Intended downcast.")
            scrollBar = CLONEABLE_WIDGET_CAST<ScrollBarWidget2D*>(enumerator.Current());
         }

         node = node->GetParent();
      }
   }

   return scrollBar;
}
