/* ***************************************************************************************
* FILE:          RichTextBaseWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RichTextBaseWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(RichTextBaseWidget2D_h)
#define RichTextBaseWidget2D_h

#include "Widgets/2D/RichTextBase/generated/RichTextBaseWidget2DBase.h"
#include "Widgets/2D/RichTextBase/RichText.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateMap.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

// ------------------------------------------------------------------------
class RichTextBaseWidget2D : public RichTextBaseWidget2DBase
{
   public:
      // constructor/destructor
      RichTextBaseWidget2D();
      ~RichTextBaseWidget2D();

      // overridden from WidgetBase
      virtual void Update();
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);
      // RTTI
      CGI_WIDGET_RTTI_DECLARATION(RichTextBaseWidget2D, RichTextBaseWidget2DBase);

      CdaWidget2DDef(RichTextBaseWidget2D, RichTextBaseWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      // overridden from RichTextWidgetBase
      virtual void OnChanged(Candera::UInt32 propertyId);

      // overridden from Widget2D
      virtual void OnBeforeNodeChanged();
      virtual void OnNodeChanged();

      // class functions
      virtual void vUpdateNode();

      virtual bool bIsReLayoutNeeded();
      virtual bool bIsReRenderNeeded();

      virtual void vLayoutRichText();
      virtual void vRenderRichText();

      bool m_bIsRelayout;
      bool m_bIsRerender;
      bool m_bIsNodeUpdate;
      bool m_bIsNodeChanged;

      FeatStd::MemoryManagement::SharedPointer<Candera::Image2D> m_pOriginalImage;
      FeatStd::MemoryManagement::SharedPointer<Candera::BitmapImage2D> m_pBitmapImage;

      RichText::RichText m_oRichText;
      RichText::StyleChunk* m_pDefaultStyleChunk;
      RichText::ParagraphChunk* m_pDefaultParagraphChunk;

      Candera::Vector2 m_oRenderOffset;
      RichText::TextArea* m_pTextArea;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(RichTextBaseWidget2D);
};


#endif // RichTextBaseWidget2D_h
